% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_apa.R
\name{chisq_apa}
\alias{chisq_apa}
\title{Report Chi-squared test in APA style}
\usage{
chisq_apa(x, print_n = FALSE, format = c("text", "markdown",
  "rmarkdown", "html", "latex", "latex_math", "docx", "plotmath"),
  info = FALSE, print = TRUE)
}
\arguments{
\item{x}{A call to \code{chisq.test}}

\item{print_n}{Logical indicating whether to show sample size in text}

\item{format}{Character string specifying the output format. One of
\code{"text"}, \code{"markdown"}, \code{"rmarkdown"}, \code{html},
\code{"latex"}, \code{"latex_math"}, \code{"docx"} or \code{"plotmath"}.}

\item{info}{Logical indicating whether to print a message on the used test
(default is \code{FALSE})}

\item{print}{Logical indicating whether to print the formatted output via
\code{cat} (\code{TRUE}, default) or return as character string.}
}
\description{
Report Chi-squared test in APA style
}
\examples{
# Example data from ?chisq.test
m <- rbind(c(762, 327, 468), c(484, 239, 477))

chisq_apa(chisq.test(m))

}
