% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoristic.plot.R
\name{aoristic.plot}
\alias{aoristic.plot}
\title{Summarize weekly aoristic weights}
\usage{
aoristic.plot(data1)
}
\arguments{
\item{data1}{a data frame output from the aoristic.df function}
}
\value{
ggplot object
}
\description{
Summarizes the sum of aoristic weights for each hour of the week, based on output from an aoristic data 
frame (created by aoristic.df). This function returns a ggplot object. 
 
NOTE: Be aware that the distribution of values is NOT the same as the aoristic.ref() output, because
the summary charts and graphs move Sunday to the end of the week to keep the weekend together.
}
\examples{
\dontrun{
aoristic.plot(aor.df)  
p <- aoristic.plot(aor.df)
}
}
\references{
Ratcliffe, J. H. (2002). Aoristic signatures and the spatio-temporal analysis of high volume crime patterns. Journal of Quantitative Criminology, 18(1), 23-43.
}
