\name{aod-pkg}
\alias{aod-pkg}
\alias{aod}
\docType{package}
\title{Analysis of Overdispersed Data}
\description{
  This package provides a set of functions to analyse overdispersed counts or proportions. Most of the methods are
  already available elsewhere but are scattered in different packages. The proposed functions should be considered as
  complements to more sophisticated methods such as generalized estimating equations (GEE) or generalized linear mixed effect
  models (GLMM).
  }
\details{
  \tabular{ll}{
    Package: \tab aod\cr
    Version: \tab 1.1-24\cr
    Date: \tab 2007-09-30\cr
    Depends: \tab R (>= 2.0.0), methods, stats\cr
    Suggests: \tab MASS, nlme, boot\cr
    License: \tab GPL version 2 or newer\cr
    URL: \tab http://cran.r-project.org/\cr
    LazyLoad: \tab yes\cr
    LazyData: \tab yes\cr
  }

Index :
\tabular{ll}{
  AIC-methods          \tab Akaike Information Criteria\cr
  aic-class            \tab Representation of Objects of Formal Class \dQuote{aic}\cr
  anova-method         \tab Likelihood-Ratio Tests for Nested ML Models\cr
  antibio              \tab Antibiotics against Shipping Fever in Calves\cr
  betabin              \tab Beta-Binomial Model for Proportions\cr
  coef-methods         \tab Methods for Function \dQuote{coef} in Package \pkg{aod}\cr
  cohorts              \tab Data set: Age, Period and Cohort Effects for Vital Rates\cr
  deviance-methods     \tab Methods for Function \code{deviance} in Package \pkg{aod}\cr
  df.residual-methods  \tab Methods for Function \code{df.residual} in Package \pkg{aod}\cr
  dja                  \tab Mortality of Djallonke Lambs in Senegal\cr
  donner               \tab Test of Proportion Homogeneity using Donner's Adjustment\cr
  drs-class            \tab Representation of Objects of Formal Class \dQuote{drs}\cr
  fitted-methods       \tab Methods for Function \code{fitted} in Package \pkg{aod}\cr
  glimML-class         \tab Representation of Models of Formal Class \dQuote{glimML}\cr
  glimQL-class         \tab Representation of Models of Formal Class \dQuote{glimQL}\cr
  icc                  \tab Intra-Cluster Correlation\cr
  icc-class            \tab Representation of Objects of Formal Class \dQuote{icc}\cr
  invlink              \tab Transformation from the Link Scale to the Observation Scale\cr
  link                 \tab Transformation from the Observation Scale to the Link Scale\cr
  lizards              \tab A Comparison of Site Preferences of Two Species of Lizard\cr
  logLik-methods       \tab Methods for Functions \dQuote{logLik} in Package \pkg{aod}\cr
  mice                 \tab Pregnant Female Mice Experiment\cr
  negbin               \tab Negative-Binomial Model for Counts\cr
  orob1                \tab Germination Data\cr
  orob2                \tab Germination Data\cr
  predict-methods      \tab Methods for Function \dQuote{predict} in Package \pkg{aod}\cr
  quasibin             \tab Quasi-Likelihood Model for Proportions\cr
  quasipois            \tab Quasi-Likelihood Model for Counts\cr
  rabbits              \tab Rabbits Foetuses Survival Experiment\cr
  raoscott             \tab Test of Proportion Homogeneity using Rao and Scott's Adjustment\cr
  rats                 \tab Rats Diet Experiment\cr
  residuals-methods    \tab Residuals for Maximum-Likelihood and Quasi-Likelihood Models\cr
  salmonella           \tab Salmonella Reverse Mutagenicity Assay\cr
  splitbin             \tab Splits Binomial Data into Bernoulli Data\cr
  summary,aic-method   \tab Akaike Information Statistics\cr
  summary.glimML-class \tab Summary of Objects of Class \dQuote{summary.glimML}\cr
  varbin               \tab Mean, Variance and Confidence Interval of a Proportion\cr
  varbin-class         \tab Representation of Objects of Formal Class \dQuote{varbin}\cr
  vcov-methods         \tab Methods for Function \dQuote{vcov} in Package \pkg{aod}\cr
  wald.test            \tab Wald Test for Model Coefficients\cr
  }
}

\author{
  Matthieu Lesnoff <matthieu.lesnoff@cirad.fr> and Renaud Lancelot <renaud.lancelot@cirad.fr>\cr
  Maintainer: Renaud Lancelot
  }
  
\keyword{package}
