% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ao.R
\name{ao}
\alias{ao}
\title{Alternating Optimization}
\usage{
ao(
  f,
  p,
  ...,
  partition = as.list(1:length(p)),
  base_optimizer = optimizeR::Optimizer$new("stats::optim"),
  iterations = 10,
  tolerance = 1e-06,
  f_partition = vector(mode = "list", length = length(partition)),
  joint_end = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{f}{A \code{function} to be optimized, returning a single \code{numeric}.
The first argument of \code{f} must be a \code{numeric} of the same length as
\code{p} followed by any other arguments specified by the \code{...}
argument.}

\item{p}{A \code{numeric} vector, the starting parameter values for the optimization.}

\item{...}{Additional arguments to be passed to \code{f}.}

\item{partition}{A \code{list} of vectors of indices of \code{p}, specifying the partition in
the alternating optimization process.
The default is \code{as.list(1:length(p))}, i.e. each parameter is
optimized separately.
Parameter indices can be members of multiple subsets.}

\item{base_optimizer}{An \code{Optimizer} object, which can be created via
\code{\link[optimizeR]{Optimizer}}.
It numerically solves the optimization problems in the partitions.}

\item{iterations}{An \code{integer}, the maximum number of iterations through
\code{partitions} before the alternating optimization process is terminated.
Can also be \code{Inf}, in which case \code{tolerance} is responsible for the
termination.
The default is \code{10}.}

\item{tolerance}{A non-negative \code{numeric}. The alternating optimization terminates
prematurely (i.e., before \code{interations} is reached) if the euclidean
distance between the current estimate and the one from the last iteration is
smaller than \code{tolerance}.
The default is \code{1e-6}.}

\item{f_partition}{A \code{list} of the same length as \code{partition}.
The \code{i}-th element can be a \code{function} that computes the value of
\code{f} for the \code{i}-th parameter set defined in \code{partition}.
The \code{function} must be of the form
\code{function(theta_part, theta_rest, ...)}, where
\itemize{
\item \code{theta_part} receives the parameter set for the current partition
(this argument can be named differently),
\item \code{theta_rest} receives the remaining parameters
(this argument must be named \code{theta_rest}),
\item \code{...} receives the additional arguments to \code{f}.
Alternatively, it can be \code{NULL}, in which case \code{f} is used.
}}

\item{joint_end}{If \code{TRUE}, the parameter set is optimized jointly after the alternating
optimization process is terminated.
The default is \code{FALSE}.}

\item{verbose}{If \code{TRUE}, full tracing details are printed during the alternating
optimization process.
The default is \code{FALSE}.}
}
\value{
A \code{list} with the elements
\itemize{
\item \code{estimate}, the optimal parameter vector found,
\item \code{value}, the value of \code{f} at \code{estimate},
\item \code{sequence}, a \code{data.frame} of the function values, estimates and
computation times in the single iterations and partitions,
\item and \code{seconds}, the overall computation time in seconds.
}
}
\description{
This function performs alternating optimization of the function \code{f}.
}
\examples{
# definition of the Himmelblau function
himmelblau <- function(x) (x[1]^2 + x[2] - 11)^2 + (x[1] + x[2]^2 - 7)^2

# alternating minimization separately for x_1 and x_2
# parameter restriction: -5 <= x_1, x_2 <= 5
ao(
  f = himmelblau, p = c(0, 0), partition = list(1, 2), iterations = Inf,
  base_optimizer = optimizeR::Optimizer$new(
    which = "stats::optim", lower = -5, upper = 5, method = "L-BFGS-B"
  )
)

}
