% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence.R
\name{anthro_prevalence}
\alias{anthro_prevalence}
\title{Compute prevalence estimates}
\usage{
anthro_prevalence(
  sex,
  age = NA_real_,
  is_age_in_month = FALSE,
  weight = NA_real_,
  lenhei = NA_real_,
  measure = NA_character_,
  headc = NA_real_,
  armc = NA_real_,
  triskin = NA_real_,
  subskin = NA_real_,
  oedema = "n",
  sw = 1,
  cluster = 1L,
  strata = 1L,
  typeres = NA_character_,
  gregion = NA_character_,
  wealthq = NA_character_,
  mothered = NA_character_,
  othergr = NA_character_
)
}
\arguments{
\item{sex}{A numeric or text variable containing gender information.
If it is numeric, its values must be: 1 for males and 2 for
females. If it is character, it must be "m" or "M" for males
and "f" or "F" for females. No z-scores will be calculated
if sex is missing.}

\item{age}{A numeric variable containing age information; age can be
in either days or months (if optional argument is_age_in_month
is set to TRUE). An exact age in days is expected and should
not be rounded if age is in months. Age-related z-scores will
NOT be calculated if age is missing (NA).}

\item{is_age_in_month}{A logical flag; if TRUE, variable age unit will be
treated as months. The function converts it to days by dividing
age by 30.4375 and rounding it to integer so that reference
tables can be used. When unspecified, the default value FALSE
is used and age unit is treated as days.}

\item{weight}{A numeric variable containing body weight information, which
must be in kilograms. Weight-related z-scores are not
calculated if body weight is missing.}

\item{lenhei}{A numeric variable containing length (recumbent length) or
height (standing height) information, which must be in
centimeters. Length/height-related z-scores will not be
calculated if lenhei is missing. For children with age
below 24 months (i.e. below 731 days) and standing height
measured, the function converts it to recumbent length by
adding 0.7 cm; and for children with age equal and above
24 months and measured in recumbent length, the function
converts it to standing height by subtracting 0.7 cm.
This way all the z-scores calculated by this function are
length-based for children below 24 months, and
height-based otherwise. This converted length/height
according to age is assigned to the variable clenhei in
the resulting data.frame.}

\item{measure}{A character variable indicating whether recumbent length
or standing height was measured for each observation.
The values of this variable must be "L" or "l" for recumbent
length, and "H" or "h" for standing height.
Although it is highly recommended that this variable
is provided according to the measurements taken in
the survey, it is possible to run the analysis without
specifying this variable. If unspecified, the default
vector with all missing values is used. The function
imputes the missing values according to the
following algorithm:
\itemize{
\item If age is not missing, then it is recumbent length
      if age below 24 months (731 days), and standing height
      if age equal and above 24 months.
\item If age is missing, then it is recumbent length if
      measurement < 87 cm and standing height
      if measurement >= 87 cm.
}}

\item{headc}{A numeric variable containing head circumference information,
which must be in centimeters. Head circumference-for-age
z-scores are not calculated if head circumference is missing.}

\item{armc}{A numeric variable containing arm circumference information,
which must be in centimeters. Arm circumference-for-age z-scores
are not calculated if arm circumference is missing.}

\item{triskin}{A numeric variable containing triceps skinfold information,
which must be in millimeters. Triceps skinfold-for-age z-scores
are not calculated if triceps skinfold is missing.}

\item{subskin}{A numeric variable containing subscapular skinfold information,
which must be in millimeters. Subscapular skinfold-for-age z-scores
are not calculated if subscapular skinfold is missing.}

\item{oedema}{The values of this character variable must be "n", "N" or "2"
for non-oedema, and "y", "Y", "1" for oedema. Although it is highly
recommended that this variable is provided by the survey,
it is possible to run
the analysis without specifying this variable. If unspecified,
the default vector of all "n" with values considered as
non-oedema is used. Missing values will be
treated as non-oedema. For oedema, weight related z-scores
(zwei, zwfl and zbmi) are NOT calculated (set to missing),
BUT they are treated as being < -3 SD in the weight-related
indicator prevalence (\code{\link{anthro_prevalence}})
estimation.}

\item{sw}{An optional numeric vector containing the sampling weights.
If unspecified, the all 1 vector is used, i.e. where all records
have equal sampling weights, and un-weighted analysis is performed.
Negative values are not allowed.}

\item{cluster}{An optional integer vector representing clusters}

\item{strata}{An optional integer vector representing strata}

\item{typeres}{An optional integer or character vector representing a type of
residence.
Any values are accepted, however, “Rural” or “Urban” are preferable
for outputs purposes.}

\item{gregion}{An optional integer or character vector representing a
geographical region.}

\item{wealthq}{An optional integer or character vector representing wealth
quintiles where (1=poorest; 2,3,4,5=richest).
All values can either be NA, or 1, 2, 3, 4, 5 or Q1, Q2, Q3, Q4, Q5.}

\item{mothered}{An optional integer or character vector representing the
education of the mother.
Any number of categories is accepted for the analysis, provided
sample sizes are sufficient in all categories. However, the common,
standard recommended categories are no education, primary school,
and secondary school or higher (“None”, “Primary” and “Secondary”).
Note: Mother education refers to the highest level of schooling
attained by the mother}

\item{othergr}{An optional integer or character vector that is of interest
for stratified analysis.}
}
\value{
Returns a data.frame with prevalence estimates for the various
groups.

The output data frame includes prevalence estimates with corresponding
standard errors and confidence intervals,
and z-score summary statistics (mean and standard deviation) with most
common cut-offs describing the full index
distribution (-3, -2, -1, +1, +2, +3), and at disaggregated levels for
all available factors (age, sex, type of residence,
geographical regions, wealth quintiles, mother education and one
additional factor the user is interested in and for which
data are available).

The resulting columns are coded with a \emph{prefix},
\emph{a prevalence indicator} and \emph{a suffix}:

\strong{Prefix:}
\describe{
 \item{HA}{Height-for-age}
 \item{WA}{Weight-for-age}
 \item{WA_2}{Underweight}
 \item{BMI}{Body-mass-index-for-age}
 \item{WH}{Weight-for-height}
 \item{HA_WH}{Height-for-age and weight-for-height combined}
}

\strong{Prevalence indicator:}
\describe{
 \item{_3}{Prevalence corresponding to < -3 SD}
 \item{_2}{Prevalence corresponding to < -2 SD}
 \item{_1}{Prevalence corresponding to < -1 SD}
 \item{1}{Prevalence corresponding to > +1 SD}
 \item{2}{Prevalence corresponding to > +2 SD}
 \item{3}{Prevalence corresponding to > +3 SD}
}

\strong{Suffix:}
\describe{
 \item{_pop}{Weighted sample size}
 \item{_unwpop}{Unweighted sample size}
 \item{_r}{Mean/prevalence}
 \item{_ll}{lower 95\% confidence interval limit}
 \item{_ul}{upper 95\% confidence interval limit}
 \item{_stdev}{Standard Deviation}
 \item{_se}{Standard error}
}


\strong{For example:}
\describe{
  \item{WHZ_pop}{Weight-for-height weighted sample size}
  \item{HA_r}{Height-for-age z-score mean}
  \item{WA_stdev}{Weight-for-age z-score Standard Deviation}
  \item{WH2_r}{Prevalence of weight-for-height >+2 SD (overweight )}
  \item{WH_r}{Mean weight-for-height z-score}
  \item{BMI_2_se}{Prevalence of BMI-for-age <-2 SD standard error}
  \item{BMI_3_ll}{Prevalence of BMI-for-age <-3 SD lower 95\% confidence
  interval limit}
  \item{HA_2_WH_2_ul}{Prevalence of children Height-for-age and
  weight-for-height combined (stunted & wasted) lower 95\% confidence
  interval limit}
}
}
\description{
Prevalence estimates according to the WHO recommended standard analysis:
includes prevalence estimates with corresponding standard errors
and confidence intervals, and z-score summary statistics
(mean and standard deviation) with most common cut-offs describing the
full index distribution (-3, -2, -1, +1, +2, +3), and at disaggregated
levels for all available factors (age, sex, type of residence,
geographical regions, wealth quintiles, mother education and one
additional factor the user is interested in and for
which data are available).
}
\details{
In this function, all available (non-missing and non-flagged) z-score values
are used for each indicator-specific prevalence
estimation (standard analysis).

Note: the function temporarily sets the \code{survey} option
\code{survey.lonely.psu} to "adjust" and then restores the original values.

If not all parameter values have equal length, parameter values will be
repeated to match the maximum length of all arguments except
\code{is_age_in_month} using \code{rep_len}. This happens without warnings.
}
\examples{
\dontrun{ # because it takes too long for CRAN checks
library(anthro)

# compute the prevalence estimates for 100 random children
# with weight around 15kg and height around 100cm
res <- anthro_prevalence(
  sex = c(1, 2),
  age = 1000, # days
  weight = rnorm(100, 15, 1),
  lenhei = rnorm(100, 100, 10)
)

# Height-for-age
# We extract prevalence estimates for <-3SD, <-2SD (Stunting)
# and the z-score mean
col_names <- c("Group", "HAZ_unwpop", "HA_3_r", "HA_2_r", "HA_r")
res <- res[, col_names]

# rename the columns
colnames(res) <- c("Group", "Unweighted N", "-3SD", "-2SD", "z-score mean ")

# note that we only generated data for one age group
res
}
}
