% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editBindingConstraint.R
\name{editBindingConstraint}
\alias{editBindingConstraint}
\title{Update an existing binding constraint}
\usage{
editBindingConstraint(
  name,
  id = tolower(name),
  values = NULL,
  enabled = NULL,
  timeStep = NULL,
  operator = NULL,
  filter_year_by_year = NULL,
  filter_synthesis = NULL,
  coefficients = NULL,
  group = NULL,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{name}{The name for the binding constraint.}

\item{id}{An id, default is to use the name.}

\item{values}{Values used by the constraint.
It contains one line per time step and three columns "less", "greater" and "equal"
(see documentation below if you're using version study >= v8.7.0)}

\item{enabled}{Logical, is the constraint enabled ?}

\item{timeStep}{Time step the constraint applies to : \code{hourly}, \code{daily} or \code{weekly}.}

\item{operator}{Type of constraint: equality, inequality on one side or both sides.}

\item{filter_year_by_year}{Marginal price granularity for year by year}

\item{filter_synthesis}{Marginal price granularity for synthesis}

\item{coefficients}{A named list containing the coefficients used by the constraint,
the coefficients have to be alphabetically ordered see examples below for entering
weight or weight with offset.}

\item{group}{"character" group of the constraint, default value : "default"}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Update an existing binding constraint in an Antares study.
The key search value of the constraint is the \code{id} field
}
\section{Warning}{

Put values with rights dimensions :
\itemize{
\item hourly : 8784
\item daily = 366
}

\strong{>= v8.7.0} : For each constraint name, one file .txt containing \verb{<id>_lt.txt, <id>_gt.txt, <id>_eq.txt}
Parameter \code{values} must be named \code{list} ("lt", "gt", "eq") containing \code{data.frame} scenarized.
see example section below.
}

\examples{
\dontrun{
 # < v8.7.0 :
editBindingConstraint(
  name = "myconstraint", 
  values = matrix(data = rep(0, 8784 * 3), ncol = 3), 
  enabled = FALSE, 
  timeStep = "hourly",
  operator = "both",
  coefficients = list("fr\%de" = 1)
)

# update binding constraint with weight + offset 
editBindingConstraint(
  name = "myconstraint", 
  values = matrix(data = rep(0, 8784 * 3), ncol = 3), 
  enabled = FALSE, 
  timeStep = "hourly",
  operator = "both",
  coefficients = list("fr\%de" = "1\%-5")
)

 # >= v8.7.0 :
 
# data values scenarized (hourly)
df <- matrix(data = rep(0, 8784 * 3), ncol = 3)
 
# you can provide list data with all value 
# or just according with 'operator' (ex : 'lt' for 'less)
values_data <- list(lt=df, 
                   gt= df, 
                   eq= df)  
                     
editBindingConstraint(name = "myconstraint", 
                      values = values_data, 
                      enabled = TRUE, 
                      timeStep = "hourly", 
                      operator = "both", 
                      filter_year_by_year = "hourly", 
                      filter_synthesis = "hourly", 
                      coefficients = list("fr\%de" = 1), 
                      group = "myconstraint_group")                   
}
}
\seealso{
Other binding constraints functions: 
\code{\link{createBindingConstraint}()},
\code{\link{removeBindingConstraint}()}
}
\concept{binding constraints functions}
