% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateOptimizationSettings.R
\name{updateOptimizationSettings}
\alias{updateOptimizationSettings}
\title{Update optimization parameters of an Antares study}
\usage{
updateOptimizationSettings(
  simplex.range = NULL,
  transmission.capacities = NULL,
  include.constraints = NULL,
  include.hurdlecosts = NULL,
  include.tc.min.stable.power = NULL,
  include.tc.min.up.down.time = NULL,
  include.dayahead = NULL,
  include.strategicreserve = NULL,
  include.spinningreserve = NULL,
  include.primaryreserve = NULL,
  include.exportmps = NULL,
  power.fluctuations = NULL,
  shedding.strategy = NULL,
  shedding.policy = NULL,
  unit.commitment.mode = NULL,
  number.of.cores.mode = NULL,
  day.ahead.reserve.management = NULL,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{simplex.range}{week or day}

\item{transmission.capacities}{true, false or infinite}

\item{include.constraints}{true or false}

\item{include.hurdlecosts}{true or false}

\item{include.tc.min.stable.power}{true or false}

\item{include.tc.min.up.down.time}{true or false}

\item{include.dayahead}{true or false}

\item{include.strategicreserve}{true or false}

\item{include.spinningreserve}{true or false}

\item{include.primaryreserve}{true or false}

\item{include.exportmps}{true or false}

\item{power.fluctuations}{free modulations, minimize excursions or minimize ramping}

\item{shedding.strategy}{share margins}

\item{shedding.policy}{shave peaks or minimize duration}

\item{unit.commitment.mode}{fast or accurate}

\item{number.of.cores.mode}{minimum, low, medium, high or maximum}

\item{day.ahead.reserve.management}{global}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}}
}
\value{
An updated list containing various information about the simulation options.
}
\description{
Update optimization parameters of an Antares study
}
