% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{principal_components_result}
\alias{principal_components_result}
\title{Easy Access to Principal Component Analysis Results}
\usage{
principal_components_result(data, results = 2)
}
\arguments{
\item{data}{list output from \code{principal_components}}

\item{results}{principal component analysis results to extract. Can use either
results name or number (i.e. pca_loadings or 2):
  \enumerate{
    \item \code{pca_sdev}
    \item \code{pca_loadings} (default)
    \item \code{pca_rotated}
    \item \code{pca_center}
    \item \code{pca_scale}
  }}
}
\value{
Returns one of the selected results:
    \enumerate{
      \item \code{pca_sdev}: the standard deviations of the principal components (i.e., the square roots of the eigenvalues of the correlation matrix, though the calculation is actually done with the singular values of the data matrix).
      \item \code{pca_loadings}: the matrix of variable loadings (i.e., a matrix whose columns contain the eigenvectors).
      \item \code{pca_rotated}: if \code{retx} is \code{TRUE} the value of the rotated data (the centred (and scaled if requested) data multiplied by the rotation matrix) is returned. Hence, \code{cov(x)} is the diagonal matrix \code{diag(sdev^2)}.
      \item \code{pca_center}: the centering used
      \item \code{pca_scale}: whether scaling was used
    }
}
\description{
\code{principal_components_result} Provides easy access to principal
component analysis results
}
\examples{

# An efficient means for getting principal component analysis results
x <- matrix(rnorm(200 * 3), ncol = 10)

principal_components(x) \%>\%
  principal_components_result(pca_loadings)

}
\seealso{
\code{\link{principal_components}} for computing the principal components results
}
