% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Anfis3-example.R
\docType{data}
\name{anfis3}
\alias{anfis3}
\title{Anfis' trained example to use for demonstration}
\format{An ANFIS trained object for demonstration.}
\source{
see \code{\link{trainSet}}
}
\description{
The example consist in learning of a bidimentional sinc(x,y) function using
a regular grid of 121 points in the domain [-10,10]x[-10,10] and
five independent Normalized Gaussian Membership Function (MF) for each input
(x and y). The training process used the Hybrid off-line Jang's strategy for
10 epochs.
}
\details{
\describe{
 \item{Trainning Set}{\itemize{
   \item dim(x)= 121x2, the grid points.
   \item dim(y)= 121x1, the sinc(x, y) output.}}
 \item{Architecture}{2 ( 5x5 ) - 25 - 75 ( 75x1 ) - 1, i. e., 2 inputs with
   five MFs in each input, 25 rules and 75 consequents for the single output
   (75x1)}
 \item{Last training error}{0.01916307}
}
}
\author{
Cristobal Fresno \email{cfresno@bdmg.com.ar}, Andrea S. Llera
 \email{ALlera@leloir.org.ar} and Elmer A. Fernandez
 \email{efernandez@bdmg.com.ar}
}
\seealso{
Other ANFIS: \code{\link{ANFIS-class}}; \code{\link{LSE}},
  \code{\link{LSE}}, \code{\link{LSE,ANFIS-method}},
  \code{\link{LSE-methods}},
  \code{\link{trainHybridJangOffLine}},
  \code{\link{trainHybridJangOffLine}},
  \code{\link{trainHybridJangOffLine,ANFIS-method}},
  \code{\link{trainHybridJangOffLine-methods}},
  \code{\link{trainHybridJangOnLine}},
  \code{\link{trainHybridJangOnLine}},
  \code{\link{trainHybridJangOnLine,ANFIS-method}},
  \code{\link{trainHybridJangOnLine-methods}},
  \code{\link{trainHybridOffLine}},
  \code{\link{trainHybridOffLine}},
  \code{\link{trainHybridOffLine,ANFIS-method}},
  \code{\link{trainHybridOffLine-methods}};
  \code{\link{coef}}, \code{\link{coef,ANFIS-method}},
  \code{\link{coefficients}},
  \code{\link{coefficients,ANFIS-method}},
  \code{\link{fitted}}, \code{\link{fitted,ANFIS-method}},
  \code{\link{fitted.values}},
  \code{\link{fitted.values,ANFIS-method}},
  \code{\link{resid}}, \code{\link{resid,ANFIS-method}},
  \code{\link{residuals}},
  \code{\link{residuals,ANFIS-method}},
  \code{\link{summary}},
  \code{\link{summary,ANFIS-method}};
  \code{\link{getConsequents}},
  \code{\link{getConsequents}},
  \code{\link{getConsequents,ANFIS-method}},
  \code{\link{getConsequents,ANFIS-method}},
  \code{\link{getErrors}}, \code{\link{getErrors}},
  \code{\link{getErrors,ANFIS-method}},
  \code{\link{getErrors,ANFIS-method}},
  \code{\link{getPremises}}, \code{\link{getPremises}},
  \code{\link{getPremises,ANFIS-method}},
  \code{\link{getPremises-methods}},
  \code{\link{getRules}}, \code{\link{getRules}},
  \code{\link{getRules,ANFIS-method}},
  \code{\link{getRules-methods}},
  \code{\link{getTrainingType}},
  \code{\link{getTrainingType}},
  \code{\link{getTrainingType,ANFIS-method}},
  \code{\link{getTrainingType,ANFIS-method}};
  \code{\link{initialize}},
  \code{\link{initialize,ANFIS-method}};
  \code{\link{plotMF}}, \code{\link{plotMF}},
  \code{\link{plotMF,ANFIS-method}},
  \code{\link{plotMF-methods}}, \code{\link{plotMFs}},
  \code{\link{plotMFs}},
  \code{\link{plotMFs,ANFIS-method}},
  \code{\link{plotMFs-methods}}; \code{\link{plot}},
  \code{\link{plot,ANFIS-method}}; \code{\link{predict}},
  \code{\link{predict,ANFIS-method}}; \code{\link{print}},
  \code{\link{print,ANFIS-method}}, \code{\link{show}},
  \code{\link{show,ANFIS-method}}; \code{\link{trainSet}}
}

