% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Anfis-trainSet.R
\name{trainSet}
\alias{trainSet}
\title{Bidimentional Sinc train set example}
\usage{
trainSet(x, y)
}
\arguments{
\item{x}{numeric vector with the x-th grid coordinates}

\item{y}{numeric vector with the x-th grid coordinates}
}
\value{
\item{matrix}{numeric matrix with the columns x, y and z=sync(x,y)}
}
\description{
Generates the training set of sinc(x)*sinc(y) for the (x,y) regular grid
}
\examples{
##Domain definition for a regular (x,y) grid with 11 points for each
##coordinates
x <- seq(-10, 10, length= 11)
trainingSet <- trainSet(x,x)
Z <- matrix(trainingSet[,"z"],ncol=length(x),nrow=length(x))

##Plot the domain
persp(x, x, Z, theta=45, phi=15, expand=0.8, col="lightblue",
 ticktype="detailed", main="sinc(x)*sinc(y)")
}
\author{
Cristobal Fresno \email{cfresno@bdmg.com.ar}, Andrea S. Llera
 \email{ALlera@leloir.org.ar} and Elmer A. Fernandez
 \email{efernandez@bdmg.com.ar}
}
\seealso{
Other ANFIS: \code{\link{ANFIS-class}}; \code{\link{LSE}},
  \code{\link{LSE}}, \code{\link{LSE,ANFIS-method}},
  \code{\link{LSE-methods}},
  \code{\link{trainHybridJangOffLine}},
  \code{\link{trainHybridJangOffLine}},
  \code{\link{trainHybridJangOffLine,ANFIS-method}},
  \code{\link{trainHybridJangOffLine-methods}},
  \code{\link{trainHybridJangOnLine}},
  \code{\link{trainHybridJangOnLine}},
  \code{\link{trainHybridJangOnLine,ANFIS-method}},
  \code{\link{trainHybridJangOnLine-methods}},
  \code{\link{trainHybridOffLine}},
  \code{\link{trainHybridOffLine}},
  \code{\link{trainHybridOffLine,ANFIS-method}},
  \code{\link{trainHybridOffLine-methods}};
  \code{\link{anfis3}}; \code{\link{coef}},
  \code{\link{coef,ANFIS-method}},
  \code{\link{coefficients}},
  \code{\link{coefficients,ANFIS-method}},
  \code{\link{fitted}}, \code{\link{fitted,ANFIS-method}},
  \code{\link{fitted.values}},
  \code{\link{fitted.values,ANFIS-method}},
  \code{\link{resid}}, \code{\link{resid,ANFIS-method}},
  \code{\link{residuals}},
  \code{\link{residuals,ANFIS-method}},
  \code{\link{summary}},
  \code{\link{summary,ANFIS-method}};
  \code{\link{getConsequents}},
  \code{\link{getConsequents}},
  \code{\link{getConsequents,ANFIS-method}},
  \code{\link{getConsequents,ANFIS-method}},
  \code{\link{getErrors}}, \code{\link{getErrors}},
  \code{\link{getErrors,ANFIS-method}},
  \code{\link{getErrors,ANFIS-method}},
  \code{\link{getPremises}}, \code{\link{getPremises}},
  \code{\link{getPremises,ANFIS-method}},
  \code{\link{getPremises-methods}},
  \code{\link{getRules}}, \code{\link{getRules}},
  \code{\link{getRules,ANFIS-method}},
  \code{\link{getRules-methods}},
  \code{\link{getTrainingType}},
  \code{\link{getTrainingType}},
  \code{\link{getTrainingType,ANFIS-method}},
  \code{\link{getTrainingType,ANFIS-method}};
  \code{\link{initialize}},
  \code{\link{initialize,ANFIS-method}};
  \code{\link{plotMF}}, \code{\link{plotMF}},
  \code{\link{plotMF,ANFIS-method}},
  \code{\link{plotMF-methods}}, \code{\link{plotMFs}},
  \code{\link{plotMFs}},
  \code{\link{plotMFs,ANFIS-method}},
  \code{\link{plotMFs-methods}}; \code{\link{plot}},
  \code{\link{plot,ANFIS-method}}; \code{\link{predict}},
  \code{\link{predict,ANFIS-method}}; \code{\link{print}},
  \code{\link{print,ANFIS-method}}, \code{\link{show}},
  \code{\link{show,ANFIS-method}}
}

