% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/databases.R
\name{databases}
\alias{databases}
\alias{as.database}
\alias{database}
\alias{database_create}
\alias{database_snapshot_create}
\alias{database_snapshots}
\alias{database_delete}
\title{Get all the available databases that can be used to create a droplet.}
\usage{
databases(...)

as.database(x)

databases(...)

database(database, ...)

database_create(
  name,
  size,
  description = NULL,
  region = "nyc1",
  snapshot_id = NULL,
  engine = NULL,
  tags = NULL,
  ...
)

database_snapshot_create(database, name, ...)

database_snapshots(database, ...)

database_delete(database, ...)
}
\arguments{
\item{...}{Additional options passed down to \code{\link[httr]{GET}},
\code{\link[httr]{POST}}, etc.}

\item{x}{Object to coerce to an database}

\item{database}{A database, or something that can be coerced to a database by
\code{\link{as.database}}.}

\item{name}{(character) Name of the new database. required.}

\item{size}{(integer) The size of the Block Storage database in GiB}

\item{description}{(character) An optional free-form text field to describe
a Block Storage database.}

\item{region}{(character) The region where the Block Storage database will
be created. When setting a region, the value should be the slug identifier
for the region. When you query a Block Storage database, the entire region
object will be returned. Should not be specified with a snapshot_id.
Default: nyc1}

\item{snapshot_id}{(integer) The unique identifier for the database snapshot
from which to create the database. Should not be specified with a region_id.}

\item{engine}{(character) The name of the engine type to be
used on the database. When provided, the database will be
created with the specified backend type. Currently, the available
options are "pg", "mysql", "redis" and "mongodb".}

\item{tags}{(character) tag names to apply to the database after it is created.
Tag names can either be existing or new tags.}
}
\value{
A data.frame with available databases (RAM, disk, no. CPU's) and
their costs
}
\description{
\describe{
\item{database}{get a single database}
\item{databases}{list databases}
\item{database_create}{create a database}
\item{database_snapshot_create}{create a snapshot of a database}
\item{database_snapshots}{list snapshots for a database}
\item{database_delete}{delete a database}
}
}
\details{
note that if you delete a database, and it has a snapshot, the
snapshot still exists, so beware
}
\examples{
\dontrun{
databases()
}
\dontrun{
# list databases
databases()

# create a database
vol1 <- database_create('testing', 5)
vol2 <- database_create('foobar', 6, tags = c('stuff', 'things'))

# create snapshot of a database
xx <- database_snapshot_create(vol2, "howdy")

# list snaphots for a database
database_snapshots(xx)

# list databases again
res <- databases()

# get a single database
## a whole database class object
database(res$testing)
## by id
database(res[[1]]$id)
## by name
database(res[[1]]$name)

# delete a database
## a whole database class object
database_delete(res$testing)
## by id
database_delete(res[[1]]$id)
## by name
database_delete(res[[1]]$name)

# delete many databases
lapply(databases(), database_delete)
}
}
