% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{droplet_do_actions}
\alias{droplet_do_actions}
\title{Perform actions on one or more droplets associated with a tag}
\usage{
droplet_do_actions(name, type, ...)
}
\arguments{
\item{name}{(character) Name of the tag. Required.}

\item{type}{(character) action type, one of 'power_cycle', 'power_on',
'power_off', 'shutdown', 'enable_private_networking', 'enable_ipv6',
'enable_backups', 'disable_backups', or 'snapshot'. Required.}

\item{...}{Additional options passed down to \code{\link[httr]{POST}}}
}
\description{
Perform actions on one or more droplets associated with a tag
}
\examples{
\dontrun{
tag_create(name = "pluto")
d <- droplet_create()
tag_resource(name = "pluto", resource_id = d$id)
(x <- droplet_do_actions(name = "pluto", type = "power_off"))
# wait until completed, check with action(xx$actions[[1]]$id)
droplet_do_actions(name = "pluto", type = "power_on")
}
}

