% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/docklet.R
\name{docklet_create}
\alias{docklet_create}
\alias{docklet_docker}
\alias{docklet_images}
\alias{docklet_ps}
\alias{docklet_pull}
\alias{docklet_rm}
\alias{docklet_rstudio}
\alias{docklet_rstudio_addusers}
\alias{docklet_run}
\alias{docklet_stop}
\title{Docklets: docker on droplets.}
\usage{
docklet_create(name = random_name(), size = getOption("do_size", "1gb"),
  region = getOption("do_region", "sfo1"),
  ssh_keys = getOption("do_ssh_keys", NULL),
  backups = getOption("do_backups", NULL), ipv6 = getOption("do_ipv6",
  NULL), private_networking = getOption("do_private_networking", NULL),
  wait = TRUE, image = "docker", ...)

docklet_ps(droplet, all = TRUE, ssh_user = "root")

docklet_images(droplet, ssh_user = "root")

docklet_pull(droplet, repo, ssh_user = "root")

docklet_run(droplet, ..., rm = FALSE, name = NULL, ssh_user = "root")

docklet_stop(droplet, container, ssh_user = "root")

docklet_rm(droplet, container, ssh_user = "root")

docklet_docker(droplet, cmd, args = NULL, docker_args = NULL,
  ssh_user = "root")

docklet_rstudio(droplet, user = "rstudio", password = "rstudio",
  email = "rstudio@example.com", img = "rocker/rstudio", port = "8787",
  volume = "", dir = "", browse = TRUE, add_users = FALSE,
  ssh_user = "root")

docklet_rstudio_addusers(droplet, user = "rstudio", password = "rstudio",
  img = "rocker/rstudio", port = "8787")
}
\arguments{
\item{name}{(character) Name of the droplet. Default: picks a random name
from \code{\link{words}} if none supplied.}

\item{size}{(character) Size slug identifier. See \code{\link{sizes}()} for
a complete list. Default: 512mb, the smallest}

\item{region}{(character) The unique slug identifier for the region that you
wish to deploy in. See \code{\link{regions}()} for a complete list.
Default: sfo1}

\item{ssh_keys}{(character) A character vector of key names, an integer
vector of key ids, or NULL, to use all keys in your account. Accounts
with the corresponding private key will be able to log in to the droplet.
See \code{\link{keys}()} for a list of the keys that you've added.
Default: NULL.}

\item{backups}{(logical) Enable backups. A boolean indicating whether
automated backups should be enabled for the droplet. Automated backups can
only be enabled when the droplet is created, and cost extra.
Default: FALSE}

\item{ipv6}{(logical) A boolean indicating whether IPv6 is enabled on the
droplet.}

\item{private_networking}{(logical) Use private networking. Private
networking is currently only available in certain regions. Default: FALSE}

\item{wait}{If \code{TRUE} (default), wait until droplet has been initialised and
is ready for use.}

\item{image}{(character/numeric) The image ID of a public or private image,
or the unique slug identifier for a public image. This image will be the
base image for your droplet. See \code{\link{images}()} for a complete
list. Default: ubuntu-14-04-x64}

\item{...}{For \code{docklet_create}, additional options passed down to
\code{\link[httr]{POST}}. For \code{docklet_run}, additional arguments combined
and applied to docker statement.}

\item{droplet}{A droplet, or something that can be coerced to a droplet by
\code{\link{as.droplet}}.}

\item{all}{(logical) List all containers. Default: \code{TRUE}}

\item{ssh_user}{(character) User account for ssh commands against droplet. Default: root}

\item{repo}{(character) Docker name, can be local to the Droplet or remote,
e.g., \code{rocker/rstudio}}

\item{rm}{(logical) Automatically remove the container when it exits.
Default: \code{FALSE}}

\item{container}{(character) Container name, can be partial (though has
to be unique)}

\item{cmd}{(character) A docker command (e.g., \code{"run"})}

\item{args}{(character) Docker args}

\item{docker_args}{(character) Docker args}

\item{user}{(character) User name. Default: \code{"rstudio"}}

\item{password}{(character) Password. Default: \code{"rstudio"}}

\item{email}{(character) Password. Default: \code{"rstudio@example.com"}}

\item{img}{(character) Docker image (not a DigitalOcean image). Default:
\code{'rocker/rstudio'}}

\item{port}{(character) Port. Default: \code{8787}}

\item{volume}{(character) Volume. Can use to bind a volume.}

\item{dir}{(character) Working directory inside the container.}

\item{browse}{(logical) If \code{TRUE}, open RStudio instance in your default
browser.}

\item{add_users}{(logical) Add users or not when installing RStudio server. Default: FALSE}
}
\description{
Docklets: docker on droplets.
}
\examples{
\dontrun{
d <- docklet_create()
d \%>\%
  docklet_pull("eddelbuettel/ubuntu-r-base") \%>\%
  docklet_images()
d \%>\% docklet_images()

d \%>\% docklet_run("eddelbuettel/ubuntu-r-base", "R --version", rm = TRUE)
d \%>\% docklet_ps()

# Run a docklet containing rstudio
d \%>\% docklet_rstudio()

# Delete a droplet
d \%>\% droplet_delete()

# Add users to an Rstudio instance
## This adds 100 users to the instance, with username/passwords
## following pattern user1/user1 ... through 100
d <- docklet_create()
d \%>\% docklet_rstudio() \%>\% docklet_rstudio_addusers()
}
}

