% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_area.R, R/hr_documentation.R,
%   R/hr_isopleths.R, R/hr_kde.R, R/hr_locoh.R, R/hr_mcp.R
\name{hr_area}
\alias{hr_area}
\alias{hr}
\alias{hr_isopleths}
\alias{hr_kde}
\alias{hr_kde.track_xy}
\alias{hr_kde_ref}
\alias{hr_kde_ref.track_xy}
\alias{hr_locoh_k}
\alias{hr_locoh_k.track_xy}
\alias{hr_mcp}
\alias{hr_mcp.track_xy}
\title{Home ranges}
\usage{
hr_area(x, ...)

hr_isopleths(x, ...)

hr_kde(x, ...)

\method{hr_kde}{track_xy}(x, h = hr_kde_ref(x), trast = raster(as_sp(x),
  nrow = 100, ncol = 100), ...)

hr_kde_ref(x, ...)

\method{hr_kde_ref}{track_xy}(x, rescale = "none", ...)

hr_locoh_k(x, ...)

\method{hr_locoh_k}{track_xy}(x, n = 10, levels = 0.95,
  rand_buffer = 1e-05, ...)

hr_mcp(x, ...)

\method{hr_mcp}{track_xy}(x, levels = 0.95, ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{mk_track} or \code{track}.}

\item{...}{Further arguments, none implemented.}

\item{h}{\code{[numeric(2)]} \cr The bandwidth for kernel density estimation.}

\item{trast}{\code{[RasterLayer]} \cr A template raster for kernel density home-ranges.}

\item{rescale}{\code{[character(1)]} \cr Rescaling method for reference bandwidth calucation. Must be one of "unitvar", "xvar", or "none".}

\item{n}{\code{[integer(1)]} \cr The number of neighbors used when calculating
local convex hulls.}

\item{levels}{\code{[numeric]} \cr The isopleth levels used for calculating home
ranges. Should be \code{0 < level < 1}.}

\item{rand_buffer}{\code{[numeric(1)]} \cr Random buffer to avoid polygons with
area 0 (if coordinates are numerically identical).}
}
\description{
Functions to calculate animal home ranges from a \code{track_xy*}, and to work
with home ranges. \code{hr_mcp}, \code{hr_kde}, and \code{hr_locoh} calculate the minimum convex
polygon, kernel density, and local convex hull home range respectively. \code{hr_area} extracts the
area of an home range, \code{hr_isopleths} returns the isopleth as a
\code{SpatialPolygonsDataFrame}.
}
\details{
The implementation of the reference bandwidth calculation is based on Worton (1989). If variances differ greatly, it is advaisable to rescale the data using \code{rescale = "unitvar"} the data is suspected to multimodal other bandwidth estimation methods may be more suitable.
}
\examples{
data(deer)


# MCP ---------------------------------------------------------------------
mcp1 <- hr_mcp(deer)
hr_area(mcp1)

# calculated MCP at different levels
mcp1 <- hr_mcp(deer, levels = seq(0.3, 1, 0.1))
hr_area(mcp1)

# CRS are inherited
get_crs(deer)
mcps <- hr_mcp(deer, levels = c(0.5, 0.95, 1))
has_crs(mcps)

# Local Convex Hull (LoCoH) -----------------------------------------------
locoh1 <- hr_locoh_k(deer)
hr_area(locoh1)

# calculated MCP at different levels
locoh <- hr_locoh_k(deer, levels = seq(0.3, 1, 0.1))
hr_area(locoh)

# CRS are inherited
get_crs(deer)
get_crs(locoh1)

# Kernel density estimaiton (KDE) -----------------------------------------
kde1 <- hr_kde(deer)
hr_area(kde1)
get_crs(kde1)
}
\references{
Worton, B. J. (1989). Kernel methods for estimating the utilization distribution in home-range studies. \emph{Ecology, 70(1)}, 164-168.
}
