% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xnet.R
\name{xnet}
\alias{xnet}
\title{Network embedding}
\usage{
xnet(Y, fm = suppressWarnings(require("network")), seed = 1)
}
\arguments{
\item{Y}{(square matrix) The sociomatrix.}

\item{fm}{(logical scalar) If TRUE, the Fruchterman-Reingold layout will
be used (requires the network package).}

\item{seed}{(integer) The random seed (the FR layout is random).}
}
\value{
(matrix) A matrix of two-dimensional coordinates.
}
\description{
Compute an embedding of a sociomatrix into a two-dimensional space.
}
\details{
Coordinates are obtained using the Fruchterman-Reingold layout if the
package \code{network} is installed, and otherwise uses the first two
eigenvectors the sociomatrix.
}
\examples{
data(addhealthc3)
Y<-addhealthc3$Y
X<-xnet(Y)
netplot(Y,X)
}
\author{
Peter Hoff
}

