% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradient.R
\name{gradient_noise}
\alias{gradient_noise}
\title{Calculate the gradient of a scalar field}
\usage{
gradient_noise(
  generator,
  x,
  y,
  z = NULL,
  t = NULL,
  ...,
  seed = NULL,
  delta = NULL
)
}
\arguments{
\item{generator}{The noise generating function, such as \link{gen_simplex}, or
\code{\link[=fracture]{fracture()}}}

\item{x, y, z, t}{The coordinates to generate the gradient for as unquoted expressions}

\item{...}{Further arguments to \code{generator}}

\item{seed}{A seed for the generator.}

\item{delta}{The offset to use for the partial derivative of the \code{generator}.
If \code{NULL}, it will be set as 1e-4 of the largest range of the dimensions.}
}
\description{
The gradient of a scalar field such as those generated by the different noise
algorithms in ambient is a vector field encoding the direction to move to get
the strongest increase in value. The vectors generated have the properties of
being perpendicular on the contour line drawn through that point. Take note
that the returned vector field flows upwards, i.e. points toward the steepest
ascend, rather than what is normally expected in a gravitational governed
world.
}
\examples{
grid <- long_grid(seq(0, 1, l = 100), seq(0, 1, l = 100))

# Use one of the generators
grid$gradient <- gradient_noise(gen_simplex, x = grid$x, y = grid$y)
plot(grid$x, grid$y, type = 'n')
segments(grid$x, grid$y, grid$x + grid$gradient$x / 100, grid$y + grid$gradient$y / 100)

}
\seealso{
Other derived values: 
\code{\link{curl_noise}()}
}
\concept{derived values}
