% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.grid.wilcox}
\alias{intFun.grid.wilcox}
\title{Wilcox significance test}
\usage{
intFun.grid.wilcox(x)
}
\arguments{
\item{x}{A raster stack object}
}
\value{
A raster object
}
\description{
This function conducts the Wilcox two-sided significance test for
two data sets that are stored in a single raster stack. The resulting raster
object shows the corresponding p-value.
}
\examples{

library(raster)
# create a raster stack
for(i in 1:100)
{
 data <- raster::raster(matrix(runif(100,0,1), ncol=10))
 assign(paste('layer', i , sep='_'), data)
}
my.list <- lapply(ls(pattern='layer_'), get)
data <- do.call(stack, my.list)
# define a, b, and c
a <- nlayers(data)/2
b <- a+1
c <- nlayers(data)
a;b;c
# conduct two-sided Wilcox significance test
pvalue <- calc(data, intFun.grid.wilcox)
plot(pvalue); text(data, digits=2)

}
\keyword{internal}
