% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.fluxnet.site.R
\name{scores.fluxnet.site}
\alias{scores.fluxnet.site}
\title{Scores for FLUXNET reference data when model run at FLUXNET site}
\usage{
scores.fluxnet.site(long.name, mod.csv, mod.csv.path, ref.csv, mod.id,
  ref.id, unit.conv.mod, unit.conv.ref, variable.unit, sites,
  score.weights = c(1, 2, 1, 1, 1), my.xlim = c(-180, 180),
  my.ylim = c(-60, 85), plot.width = 8, plot.height = 3.8,
  numCores = 2, outputDir = FALSE)
}
\arguments{
\item{long.name}{A string that gives the full name of the variable, e.g. 'Gross primary productivity'}

\item{mod.csv}{A string that gives the name of the model output in csv format, e.g. 'gpp_monthly.csv'}

\item{mod.csv.path}{A string that gives the path to the model output for site-level runs}

\item{ref.csv}{A string that gives the path and name of the csv file that contains the reference data output, e.g. '/home/reference_gpp.csv'. The columns of this file should contain latitude, longitude, date, variable of interest, and site name.}

\item{mod.id}{A string that identifies the source of the reference data set, e.g. 'CanESM2'}

\item{ref.id}{A string that identifies the source of the reference data set, e.g. 'MODIS'}

\item{unit.conv.mod}{A number that is used as a factor to convert the unit of the model data, e.g. 86400}

\item{unit.conv.ref}{A number that is used as a factor to convert the unit of the reference data, e.g. 86400}

\item{variable.unit}{A string that gives the final units using LaTeX notation, e.g. 'gC m$^{-2}$ day$^{-1}$'}

\item{sites}{A vector of strings that give the fluxnet site names, e.g.  c('AU-Tum','BR-Sa1','CA-Qfo')}

\item{score.weights}{R object that gives the weights of each score (\eqn{S_{bias}}, \eqn{S_{rmse}}, \eqn{S_{phase}}, \eqn{S_{iav}}, \eqn{S_{dist}})
that are used for computing the overall score, e.g. c(1,2,1,1,1)}

\item{my.xlim}{An R object that gives the longitude range that you wish to
plot, e.g. c(-180, 180)}

\item{my.ylim}{An R object that gives the longitude range that you wish to
plot, e.g. c(-90, 90)}

\item{plot.width}{Number that gives the plot width, e.g. 8}

\item{plot.height}{Number that gives the plot height, e.g. 4}

\item{numCores}{An integer that defines the number of cores, e.g. 2}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
(1) Figures in PDF format that show maps of
the model data at the location of FLUXNET sites
(mean, \eqn{mod.mean}; interannual-variability, \eqn{mod.iav}; month of annual cycle maximum, \eqn{mod.max.month}),
the reference data
(mean, \eqn{ref.mean}; interannual-variability, \eqn{ref.iav}; month of annual cycle maximum, \eqn{ref.max.month}),
statistical metrics
(bias, \eqn{bias}; centralized root mean square error, \eqn{crmse}; time difference of the annual cycle maximum, \eqn{phase}),
and scores
(bias score, \eqn{bias.score}; root mean square error score, \eqn{rmse.score}; inter-annual variability score \eqn{iav.score}; annual cycle score (\eqn{phase.score}).

(2) Four text files: (i) score values and (ii) score inputs for each individual
site, and (iii) score values and (iv) score inputs averaged across sites.
when averaging over all station.
}
\description{
This function compares model output in CSV format against
FLUXNET measurements in CSV format. Use this function when running your model
at each FLUXNET site individually. The performance of a model is
expressed through scores that range from zero to one, where increasing values
imply better performance. These scores are computed in five steps:
\eqn{(i)} computation of a statistical metric,
\eqn{(ii)} nondimensionalization,
\eqn{(iii)} conversion to unit interval,
\eqn{(iv)} spatial integration, and
\eqn{(v)} averaging scores computed from different statistical metrics.
The latter includes the bias, root-mean-square error, phase shift,
inter-annual variability, and spatial distribution. The corresponding equations
are documented in \code{\link{amber-package}}.
}
\examples{
\donttest{
library(amber)
library(doParallel)
library(foreach)
library(ncdf4)
library(parallel)
library(raster)

long.name <- 'Gross primary productivity'
mod.csv <- 'gpp_monthly.csv'
mod.csv.path <- system.file('extdata/siteLevelRun', package = 'amber')
ref.csv <- system.file('extdata/referenceRegular', 'gpp_monthly_fluxnet.csv', package = 'amber')
mod.id <- 'CLASSIC-Sitelevel' # define a model experiment ID
ref.id <- 'FLUXNET' # give reference dataset a name
unit.conv.mod <- 86400*1000 # optional unit conversion for model data
unit.conv.ref <- 1 # optional unit conversion for reference data
variable.unit <- 'gC m$^{-2}$ day$^{-1}$' # unit after conversion (LaTeX notation)
sites <- c('AU-Tum', 'CA-TPD', 'CZ-BK1', 'DK-Sor', 'FR-Fon', 'GH-Ank', 'IT-Tor',
 'PA-SPs', 'RU-Ha1', 'US-WCr', 'ZM-Mon', 'BR-Sa1', 'CG-Tch', 'DE-Kli', 'ES-LgS',
 'FR-Pue', 'IT-Lav', 'MY-PSO', 'RU-Che', 'RU-SkP', 'US-Wkg', 'CA-Qfo', 'CN-Dan',
 'DE-Tha', 'FI-Hyy', 'GF-Guy', 'IT-SRo', 'NL-Loo', 'RU-Fyo', 'SD-Dem', 'ZA-Kru')

# Short version using default settings:
scores.fluxnet.site(long.name, mod.csv, mod.csv.path, ref.csv, mod.id, ref.id,
unit.conv.mod, unit.conv.ref, variable.unit, sites)

# Additional parameters:
score.weights <- c(1,2,1,1,1) # score weights of S_bias, S_rmse, S_phase, S_iav, S_dist
my.xlim <- c(-180, 180)
my.ylim <- c(-60, 85)
plot.width <- 8
plot.height <- 3.8
numCores <- 2

scores.fluxnet.site(long.name, mod.csv, mod.csv.path, ref.csv, mod.id, ref.id,
unit.conv.mod, unit.conv.ref, variable.unit, sites, score.weights,
my.xlim, my.ylim, plot.height, numCores)

# To zoom into a particular region:
scores.fluxnet.site(long.name, mod.csv, mod.csv.path, ref.csv, mod.id, ref.id,
unit.conv.mod, unit.conv.ref, variable.unit, sites,
my.xlim = c(-150, -60), my.ylim = c(20, 60), plot.width = 6, plot.height = 3.8)
}
}
