% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.min.max.int.bias}
\alias{intFun.min.max.int.bias}
\title{Range and interval for color bar legend (bias)}
\usage{
intFun.min.max.int.bias(x)
}
\arguments{
\item{x}{An R object}
}
\value{
Minimum, maximum, and interval value for color bar legend used for
plotting biases.
}
\description{
This function returns the minimum, maximum, and interval value
that can be used to define a color bar legend for plotting biases. The
function ensures that the absolute values of the minimum and maximum are
identical. For instance, consider a bias that ranges from -10 to 300.
The resulting minimum and maximum value used by the color scheme are then
- 300 and 300, respectively.
}
\examples{

library(raster)
library(spatial.tools)
library(classInt)
# create a raster object
data <- runif(100,-23,864)
data <- matrix(data, ncol=10)
data <- raster::raster(data)
# Get min, max, and interval for color bar legend
mmi <- intFun.min.max.int.bias(data)

}
\keyword{internal}
