% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_geos}
\alias{process_geos}
\title{Process atmospheric composition data}
\usage{
process_geos(
  date = c("2018-01-01", "2018-01-01"),
  variable = NULL,
  path = NULL,
  extent = NULL,
  ...
)
}
\arguments{
\item{date}{character(2). length of 10. Format "YYYY-MM-DD".}

\item{variable}{character(1). GEOS-CF variable name(s).}

\item{path}{character(1). Directory with downloaded netCDF (.nc4) files.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatRaster} object;
}
\description{
The \code{process_geos()} function imports and cleans raw atmospheric
composition data, returning a single \code{SpatRaster} object.
}
\note{
Layer names of the returned \code{SpatRaster} object contain the variable,
pressure level, date, and hour.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
geos <- process_geos(
  date = c("2024-01-01", "2024-01-10"),
  variable = "O3",
  path = "./data/aqc_tavg_1hr_g1440x721_v1"
)
}
}
\author{
Mitchell Manware
}
