#' Error handling for incorrect object inputs to api.R calls
#'
#' @param object An R object
#' @param type Expected \code{class} of \code{object}
check_class <- function(object, type) {
  error_message <-
    "argument '{class}' must be an object of class 'alteryx_{class}"
  error_message <-
    gsub("\\{class\\}", type, error_message)

  what <- paste0("alteryx_", type)

  if(!inherits(object, what))
    stop(error_message)
}

#' Error handling for non-200 status codes
#'
#' @param response Response generated by a request such as \code{httr::GET}
#' or \code{httr::POST}
check_status <- function(response) {
  status <- httr::status_code(response)

  if(status != "200") {
    content <- httr::content(response)
    if("message" %in% names(content)) {
      stop(paste(status, content$exceptionName, content$message))
      return(response)
    } else {
      stop(paste(status, "Unexpected Response"))
      return(response)
    }
  }

  return(response)
}

#' Check Keys
#'
#' @param type "source" or "target"
check_keys <- function(type = "source") {

  ev_list <- c(
    "alteryx_api_key",
    "alteryx_secret_key",
    "alteryx_gallery"
  )

  if(type == "target") {
    ev_list <- paste0("target_", ev_list)
  }

  ev <- lapply(ev_list, function(x) getOption(x))
  names(ev) <- ev_list

  m <- paste("'", ev_list[1],
             "', '", ev_list[2],
             "', and/or '", ev_list[3],
             "' not set as options.")

  if(
    length(ev) != length(ev_list)
  )
    stop(m)

  return(NULL)
}
