% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{data}
\name{alt}
\alias{alt}
\title{Altair object}
\format{
An object of class \code{python.builtin.module} (inherits from \code{python.builtin.object}) of length 1.
}
\usage{
alt
}
\description{
Uses the reticulate framework to access the Altair API.
}
\details{
The Altair Python package is exposed through the \code{alt} object.
You can create and add to chart using its methods and classes,
as outlined in the
\href{https://altair-viz.github.io/index.html}{Altair Python documentation}.

In this package, use the \code{$} operator wherever you see the \code{.} operator
used in Python.
}
\examples{
if (interactive()) {
  vega_data <- import_vega_data()

  plot_basic <-
    alt$Chart(vega_data$cars())$
    encode(
      x = "Miles_per_Gallon:Q",
      y = "Horsepower:Q",
      color = "Origin:N"
    )$
    mark_point()

   plot_basic
}

}
\seealso{
\href{https://altair-viz.github.io/index.html}{Altair Python documentation},
\href{https://vegawidget.github.io/altair/articles/field-guide-python.html}{altair: Field Guide to Python Issues}
}
\keyword{datasets}
