open_allcontribs_issue <- function (org, repo, ctbs) {
    x <- get_gh_issue_titles (org, repo)
    if (!"all contributors" %in% tolower (x$title)) {
        logins <- ctbs$logins [which (!ctbs$logins == get_git_user ())]
        b <- paste0 (
            "Hi All! This repository uses the ",
            "\u005B\\`allcontributors\\` package\u005D",
            "\u0028https://github.com/ropenscilabs/",
            "allcontributors\u0029 ",
            "to acknowledge all contributions on the main ",
            "\u005B\\`README\\`\u005D",
            "\u0028https://github.com/", org, "/", repo, "\u0029 ",
            "This issue has been automatically generated by the ",
            "\u005B\\`addcontributors\\` function\u005D",
            "\u0028https://docs.ropensci.org/allcontributors/",
            "reference/add_contributors.html\u0029",
            " in order to ping you that you've been acknowledged. ",
            "Thank you all:\n\n"
        )
        for (l in logins) {
            b <- paste0 (b, "@", l, "\n")
        }
        b <- paste0 (
            b, "\n\n\u0028Issue may be closed immediately, ",
            "and will be re-opened ",
            "each time new contributors are added when running the ",
            "\u005B\\`addcontributors\\` function\u005D",
            "\u0028https://docs.ropensci.org/allcontributors/",
            "reference/add_contributors.html\u0029.\u0029"
        )
        args <- c (
            "issue", "create",
            "--title", "\"All Contributors\"",
            "--body", paste0 ("\"", b, "\""),
            "--web"
        )
        system2 ("gh", args = args)

        if (length (logins) > 51) {
            m <- paste0 (
                "You have more than 50 contributors, yet ",
                "github only allows a maximum of 50 people ",
                "to be notified in one issue comment.\n",
                "You'll have to manually edit the issue ",
                "to divide the list into multiple individual ",
                "comments in order for all of your ",
                "contributors to be notified."
            )
            cli::cli_alert_warning (m, wrap = TRUE)
        }
    }
}

extend_allcontribs_issue <- function (org, repo, ctbs, issue_num) {

    pings <- get_gh_contrib_issue (org, repo)
    pings <- pings [which (!pings %in% ctbs$login)]
    message (
        cli::col_cyan (cli::symbol$Star),
        " The following new contributors have been ",
        "copied to the clipboard:"
    )
    ulid <- cli::cli_ul ()
    for (p in pings) {
        cli::cli_li (p)
    }
    cli::cli_end (ulid)


    titles <- get_gh_issue_titles (org, repo)
    issue_num <- titles$number [grep ("all contrib", tolower (titles$title))]
    if (length (issue_num) == 0) {
        stop ("There is no 'All Contributions' issue")
    }

    args <- c ("issue", "view", issue_num, "--web")
    system2 ("gh", args = args)

    invisible (clipr::write_clip (pings))
}
