% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/signal.R
\docType{methods}
\name{signal_correct}
\alias{signal_correct}
\alias{signal_correct-method}
\alias{signal_correct,numeric,numeric-method}
\alias{signal_correct,ANY,missing-method}
\title{Baseline Correction}
\usage{
signal_correct(x, y, ...)

\S4method{signal_correct}{numeric,numeric}(x, y, method = c("linear", "rubberband", "SNIP", "4S"), ...)

\S4method{signal_correct}{ANY,missing}(x, method = c("linear", "rubberband", "SNIP", "4S"), ...)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Extra arguments to be passed to \verb{baseline_*()} (see details).}

\item{method}{A \code{\link{character}} string specifying the method for baseline
estimation. It must be one of "\code{linear}", "\code{rubberband}", "\code{SNIP}" or "\verb{4S}"
(see details). Any unambiguous substring can be given.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Baseline Correction
}
\details{
Available methods for baseline estimation:
\describe{
\item{\code{linear}}{Linear baseline estimation (see \code{\link[=baseline_linear]{baseline_linear()}}).}
\item{\code{rubberband}}{Rubberband baseline estimation (see
\code{\link[=baseline_rubberband]{baseline_rubberband()}}).}
\item{\code{SNIP}}{Sensitive Nonlinear Iterative Peak clipping algorithm
(see \code{\link[=baseline_snip]{baseline_snip()}}).}
\item{\verb{4S}}{4S Peak Filling (see \code{\link[=baseline_peakfilling]{baseline_peakfilling()}}).}
}
}
\examples{
## gamma-ray spectrometry
data("BEGe")

## Subset from 2.75 to 200 keV
BEGe <- signal_select(BEGe, from = 3, to = 200)

## Drift
baseline <- baseline_snip(BEGe)
BEGe_drif <- signal_drift(BEGe, lag = baseline, subtract = TRUE)

plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")
lines(BEGe_drif, type = "l", col = "red")

## Correct
BEGe_corr <- signal_correct(BEGe, method = "SNIP")

plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")
lines(BEGe_corr, type = "l", col = "red")
}
\seealso{
Other signal processing methods: 
\code{\link{signal_bind}()},
\code{\link{signal_drift}()},
\code{\link{signal_mean}()},
\code{\link{signal_shift}()},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{signal processing methods}
