% Generated by roxygen2 (4.0.1): do not edit by hand
\name{latteMin}
\alias{latteMin}
\title{Solve a Linear Program (Minimization)}
\usage{
latteMin(objective, constraints, method = c("lp", "cones"), dir = tempdir(),
  opts = "", quiet = TRUE)
}
\arguments{
\item{objective}{a linear polynomial to pass to \code{\link{mp}}, see examples}

\item{constraints}{a collection of linear polynomial (in)equalities that define the feasibility region, the integers in the polytope}

\item{method}{method LP or cones}

\item{dir}{directory to place the files in, without an ending /}

\item{opts}{options; see the LattE manual at \url{http://www.math.ucdavis.edu/~latte}}

\item{quiet}{show latte output}
}
\value{
the count.  if the count is a number has less than 10 digits, an integer is returned.  if the number has 10 or more digits, an integer in a character string is returned. you may want to use the gmp package's as.bigz to parse it.
}
\description{
\code{latteMin} uses LattE's minimize function to find the minimum of a linear objective function over the integers satisfying linearity constraints.  This makes use of the digging algorithm; see the LattE manual at \url{http://www.math.ucdavis.edu/~latte} for details.
}
\examples{
\dontrun{

latteMin("-2 x + 3 y", c("x + y <= 10", "x >= 0", "y >= 0"))
latteMin("-2 x + 3 y", c("x + y <= 10", "x >= 0", "y >= 0"),
  method = "cones") # ??


df <- expand.grid(x = 0:10, y = 0:10)
df <- subset(df, x + y <= 10)
df$val <- apply(df, 1, function(v) -2*v[1] + 3*v[2])
df[which.min(df$val),]

library(ggplot2)
qplot(x, y, data = df, size = val)









latteMin("-2 x - 3 y - 4 z", c(
  "3 x + 2 y + z <= 10",
  "2 x + 5 y + 3 z <= 15",
  "x >= 0", "y >= 0", "z >= 0"
), "cones",quiet = FALSE)

df <- expand.grid(x = 0:10, y = 0:10, z = 0:10)
df <- subset(df,
  (3*x + 2*y + 1*z <= 10) &
  (2*x + 5*y + 3*z <= 15)
)

df$val <- apply(df, 1, function(v) -2*v[1] + -3*v[2] + -4*v[3])
df[which.min(df$val),]




}
}

