% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ale_core.R
\name{ale_ixn}
\alias{ale_ixn}
\title{Create and return ALE interaction data, statistics, and plots}
\usage{
ale_ixn(
  data,
  model,
  x1_cols = NULL,
  x2_cols = NULL,
  y_col = NULL,
  ...,
  output = c("plots", "data"),
  pred_fun = function(object, newdata) {
     stats::predict(object = object, newdata =
    newdata, type = pred_type)
 },
  pred_type = "response",
  x_intervals = 100,
  relative_y = "median",
  y_type = NULL,
  median_band = 0.05,
  rug_sample_size = 500,
  min_rug_per_interval = 1,
  ale_xs = NULL,
  n_x1_int = 20,
  n_x2_int = 20,
  n_y_quant = 10,
  silent = FALSE
)
}
\arguments{
\item{data}{See documentation for \code{ale}}

\item{model}{See documentation for \code{ale}}

\item{x1_cols, x2_cols}{character. Vectors of column names from \code{data} for which
two-way interaction ALE data is to be calculated. ALE data will be calculated
for each x1 column interacting with each x2 column. x1_cols can be of any standard
datatype (logical, factor, or numeric) but x2_cols can only be numeric. If
\code{ixn} is TRUE, then both values must be provided.}

\item{y_col}{See documentation for \code{ale}}

\item{...}{not used. Inserted to require explicit naming of subsequent arguments.}

\item{output}{See documentation for \code{ale}}

\item{pred_fun, pred_type}{See documentation for \code{ale}}

\item{x_intervals}{See documentation for \code{ale}}

\item{relative_y}{See documentation for \code{ale}}

\item{y_type}{See documentation for \code{ale}}

\item{median_band}{See documentation for \code{ale}}

\item{rug_sample_size, min_rug_per_interval}{See documentation for \code{ale}}

\item{ale_xs}{See documentation for \code{ale}}

\item{n_x1_int, n_x2_int}{positive scalar integer. Number of intervals
for the x1 or x2 axes respectively for interaction plot. These values are
ignored if x1 or x2 are not numeric (i.e, if they are logical or factors).}

\item{n_y_quant}{positive scalar integer. Number of intervals over which the range
of y values is divided for the colour bands of the interaction plot. See details.}

\item{silent}{See documentation for \code{ale}}
}
\value{
list of ALE interaction data tibbles and plots.
The list has two levels of depth:
\itemize{
\item The first level is named by the x1 variables.
\item Within each x1 variable list, the second level is named by the x2 variables.
\item Within each x1-x2 list element, the data or plot is returned as requested in
the \code{output} argument.
}
}
\description{
This is the central function that manages the creation of ALE data and plots
for two-way ALE interactions. For simple one-way ALE, see \code{ale}.
See documentation there for functionality shared between both functions.
For details, see the introductory vignette for this package or the details and examples below.

For the plots, \code{n_y_quant} is the number of quantiles into which to
divide the predicted variable (y). The middle quantiles are grouped specially:
\itemize{
\item The middle quantile is the \code{median_band} confidence interval around the median.
This middle quantile is special because it generally represents no meaningful
interaction.
\item The quantiles above and below the middle are extended from the borders of
the middle quantile to the regular borders of the other quantiles.
}

There will always be an odd number of quantiles: the special middle quantile
plus an equal number of quantiles on each side of it. If n_y_quant is even,
then a middle quantile will be added to it. If n_y_quant is odd, then the
number specified will be used, including the middle quantile.
}
\examples{

diamonds
set.seed(0)
diamonds_sample <- diamonds[sample(nrow(diamonds), 1000), ]

# Split the dataset into training and test sets
# https://stackoverflow.com/a/54892459/2449926
set.seed(0)
train_test_split <- sample(
  c(TRUE, FALSE), nrow(diamonds_sample), replace = TRUE, prob = c(0.8, 0.2)
)
diamonds_train <- diamonds_sample[train_test_split, ]
diamonds_test <- diamonds_sample[!train_test_split, ]


# Create a GAM model with flexible curves to predict diamond price
# Smooth all numeric variables and include all other variables
# Build model on training data, not on the full dataset.
gam_diamonds <- mgcv::gam(
  price ~ s(carat) + s(depth) + s(table) + s(x) + s(y) + s(z) +
    cut + color + clarity,
  data = diamonds_train
)
summary(gam_diamonds)

# ALE two-way interactions
ale_ixn_gam_diamonds <- ale_ixn(diamonds_test, gam_diamonds)


\donttest{
# Print interaction plots
ale_ixn_gam_diamonds$plots |>
  purrr::walk(\(.x1) {  # extract list of x1 ALE outputs
    gridExtra::grid.arrange(grobs = .x1, ncol = 2)  # plot all x1 plots
  })
}


}
