% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AxialShapeGraph.R
\docType{methods}
\name{linkRefs,AxialShapeGraph-method}
\alias{linkRefs,AxialShapeGraph-method}
\title{Link two Axial Lines (refs)}
\usage{
\S4method{linkRefs}{AxialShapeGraph}(map, fromRef, toRef, copyMap = TRUE)
}
\arguments{
\item{map}{An Axial ShapeGraph}

\item{fromRef}{Ref of the first link line}

\item{toRef}{Ref of the second link line}

\item{copyMap}{Optional. Copy the internal sala map}
}
\value{
A new Axial ShapeGraph with linked lines
}
\description{
Link two lines on an Axial ShapeGraph using their refs
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
linkRefs(shapeGraph, 0L, 9L)
}
