% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegmentShapeGraph.R
\docType{methods}
\name{connections,SegmentShapeGraph-method}
\alias{connections,SegmentShapeGraph-method}
\title{Get the Segment ShapeGraph connections}
\usage{
\S4method{connections}{SegmentShapeGraph}(map)
}
\arguments{
\item{map}{An Segment ShapeGraph}
}
\value{
A matrix with the connected refs
}
\description{
Get the Segment ShapeGraph connections
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_segment_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "SegmentShapeGraph")
connections(shapeGraph)
}
