% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTopFeatures.R
\name{getTopFeatures}
\alias{getTopFeatures}
\title{Extract top x percent of features}
\usage{
getTopFeatures(lineStringMap, column, percent)
}
\arguments{
\item{lineStringMap}{An sf lineString map}

\item{column}{The column to use to extract the features from}

\item{percent}{Percentage of features (to total) to extract}
}
\value{
The lineString map filtered and sorted
}
\description{
Sorts features by a specific column and extracts the top x percent
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
result <- allToAllTraverse(
  shapeGraph,
  traversalType = TraversalType$Topological,
  radii = c("n", "3"),
  includeBetweenness = TRUE
)
getTopFeatures(as(shapeGraph, "sf"), "df_2_Connectivity", 0.1)
}
