% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{getSeqMatrix}
\alias{getSeqMatrix}
\title{Calculate pairwise distances between sequences}
\usage{
getSeqMatrix(seq, dist_mat = getDNAMatrix(gap = -1))
}
\arguments{
\item{seq}{character vector containing a DNA sequences.}

\item{dist_mat}{Character distance matrix. Defaults to a Hamming distance 
matrix returned by \code{\link{getDNAMatrix}}. If gap 
characters, \code{c("-", ".")}, are assigned a value of -1 
in \code{dist_mat} then contiguous gaps of any run length,
which are not present in both sequences, will be counted as a 
distance of 1. Meaning, indels of any length will increase
the sequence distance by 1. Gap values other than -1 will 
return a distance that does not consider indels as a special case.}
}
\value{
A matrix of numerical distance between each entry in \code{seq}. 
          If \code{seq} is a named vector, row and columns names will be added 
          accordingly.
}
\description{
\code{getSeqMatrix} calculates all pairwise distance between a set of sequences.
}
\examples{
# Gaps will be treated as Ns with a gap=0 distance matrix
getSeqMatrix(c(A="ATGGC", B="ATGGG", C="ATGGG", D="AT--C"), 
             dist_mat=getDNAMatrix(gap=0))

# Gaps will be treated as universally non-matching characters with gap=1
getSeqMatrix(c(A="ATGGC", B="ATGGG", C="ATGGG", D="AT--C"), 
             dist_mat=getDNAMatrix(gap=1))

# Gaps of any length will be treated as single mismatches with a gap=-1 distance matrix
getSeqMatrix(c(A="ATGGC", B="ATGGG", C="ATGGG", D="AT--C"), 
             dist_mat=getDNAMatrix(gap=-1))

}
\seealso{
Uses \code{\link{getSeqDistance}} for calculating distances between pairs.
          Nucleotide distance matrix may be built with \code{\link{getDNAMatrix}}. 
          Amino acid distance matrix may be built with \code{\link{getAAMatrix}}.
}

