% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRollingWindowAKI.R
\name{addRollingWindowAKI}
\alias{addRollingWindowAKI}
\title{Add in rolling-window AKI}
\usage{
addRollingWindowAKI(
  dataframe,
  window1 = as.difftime(2, units = "days"),
  window2 = as.difftime(7, units = "days"),
  add_min_creat = FALSE
)
}
\arguments{
\item{dataframe}{patient dataset}

\item{window1}{rolling window length of the shorter time window; defaults to 48 hours}

\item{window2}{rolling window length of the longer time window; defaults to 162 hours}

\item{add_min_creat}{boolean to add the intermediate columns generated during calculation}
}
\value{
patient dataset with the rolling-window AKI column added in

#Imports
}
\description{
Add in the AKI column in a patient dataframe according to the rolling-window KDIGO criterion
}
\examples{
library(dplyr)
toy <- toy \%>\% rename('patient_id' = 'mrn', 'encounter_id' = 'enc', 'inpatient' = 'inpatient',
'creatinine' = 'creat', 'admission' = 'admission', 'time' = 'time')
toy <- transform(toy, time = as.POSIXct(time, format='\%Y-\%m-\%d \%H:\%M:\%S'),
admission = as.POSIXct(admission, format='\%Y-\%m-\%d \%H:\%M:\%S'))
addRollingWindowAKI(toy)
}
