% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateController.R
\name{CreateController}
\alias{CreateController}
\title{Creation and adding of a controller in a supervisor}
\usage{
CreateController(supervisor, ctrl.id, Y, U, FUN)
}
\arguments{
\item{supervisor}{\code{Supervisor} object, see \link{CreateSupervisor}}

\item{ctrl.id}{\link{character} id of the controller (see Details)}

\item{Y}{\link{character} location of the controlled and/or measured variables in the model.}

\item{U}{\link{character} location of the command variables in the model.}

\item{FUN}{\link{function} controller logic which calculates \code{U} from \code{Y} (see Details)}
}
\value{
a \code{Controller} object which is a list with the following items:
\itemize{
\item \code{id} \link{character}: the controller identifier
\item \code{U} \link{matrix}: the list of controls for command variables with each column being the location of the variables and the rows being
the values of the variable for the current time steps (empty by default)
\item \code{Unames} \link{character}: location of the command variables
\item \code{Y} \link{matrix}: the lists of controls for controlled variables with each column being the location of the variables and the rows being
the values of the variable for the current time steps (empty by default)
\item \code{Ynames} \link{character}: location of the controlled variables
\item \code{FUN} \link{function}: controller logic which calculates \code{U} from \code{Y}
}
}
\description{
Creation and adding of a controller in a supervisor
}
\details{
The \code{ctrl.id} is a unique id for finding the controller in the supervisor.
If a controller with the same id already exists, it is overwritten by this new one.

\code{FUN} should be a function with one \link{numeric} parameter.
This parameter will receive the measured values of at \code{Y} locations as input
for the previous time step and returns calculated \code{U}. These \code{U} will then be applied
at their location for the current time step of calculation of the model.
}
\examples{
# First create a Supervisor from a model
data(Severn)
nodes <- Severn$BasinsInfo[, c("gauge_id", "downstream_id", "distance_downstream", "area")]
nodes$model <- "RunModel_GR4J"
griwrm <- CreateGRiwrm(nodes,
                 list(id = "gauge_id",
                      down = "downstream_id",
                      length = "distance_downstream"))
BasinsObs <- Severn$BasinsObs
DatesR <- BasinsObs[[1]]$DatesR
PrecipTot <- cbind(sapply(BasinsObs, function(x) {x$precipitation}))
PotEvapTot <- cbind(sapply(BasinsObs, function(x) {x$peti}))
Qobs <- cbind(sapply(BasinsObs, function(x) {x$discharge_spec}))
Precip <- ConvertMeteoSD(griwrm, PrecipTot)
PotEvap <- ConvertMeteoSD(griwrm, PotEvapTot)
InputsModel <- CreateInputsModel(griwrm, DatesR, Precip, PotEvap, Qobs)
sv <- CreateSupervisor(InputsModel)

# A controller which usually releases 0.1 m3/s and provides
# extra release if the downstream flow is below 0.5 m3/s
logicDamRelease <- function(Y) max(0.5 - Y[1], 0.1)
CreateController(sv, "DamRelease", Y = c("54001"), U = c("54095"), FUN = logicDamRelease)
}
