% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_agreement.R
\name{plot_agreement}
\alias{plot_agreement}
\title{Visualize Agreement}
\usage{
plot_agreement(
  Y,
  D,
  Z,
  A,
  subgroup1,
  subgroup2,
  label.subgroup1 = "Subgroup 1",
  label.subgroup2 = "Subgroup 2",
  x.order = NULL,
  p.title = NULL,
  p.lb = -0.3,
  p.ub = 0.3,
  y.lab = "Impact of PSA"
)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{A}{An AI recommendation (binary: numeric vector of 0 or 1).}

\item{subgroup1}{A pretreatment covariate used for subgroup analysis (vector).}

\item{subgroup2}{A pretreatment covariate used for subgroup analysis (vector).}

\item{label.subgroup1}{A label for subgroup1 (character). Default "Subgroup 1".}

\item{label.subgroup2}{A label for subgroup2 (character). Default "Subgroup 2".}

\item{x.order}{An order for the x-axis (character vector). Default NULL.}

\item{p.title}{A title for the plot (character). Default NULL.}

\item{p.lb}{A lower bound for the y-axis (numeric). Default -0.3.}

\item{p.ub}{An upper bound for the y-axis (numeric). Default 0.3.}

\item{y.lab}{A label for the y-axis (character). Default "Impact of PSA".}
}
\value{
A ggplot object.
}
\description{
Visualize the agreement between human decisions and AI recommendations using a difference-in-means estimator of an indicator \eqn{1\{D_i = A_i\}}.
Generate a plot based on the overall agreement and subgroup-specific agreement.
}
\examples{
plot_agreement(
  Y = NCAdata$Y,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  A = PSAdata$DMF,
  subgroup1 = ifelse(NCAdata$White == 1, "White", "Non-white"),
  subgroup2 = ifelse(NCAdata$Sex == 1, "Male", "Female"),
  label.subgroup1 = "Race",
  label.subgroup2 = "Gender",
  x.order = c("Overall", "Non-white", "White", "Female", "Male")
)

}
