% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequentist_re.R
\name{TestMonotonicityRE}
\alias{TestMonotonicityRE}
\title{Test monotonicity with random effects}
\usage{
TestMonotonicityRE(data, formula)
}
\arguments{
\item{data}{A \code{data.frame} or \code{matrix} of which columns consists of pre-treatment covariates, a binary treatment (Z), an ordinal decision (D), and an outcome variable (Y). The column names of the latter three should be specified as "Z", "D", and "Y" respectively.}

\item{formula}{A formula of the model to fit.}
}
\value{
Message indicating whether the monotonicity assumption holds.
}
\description{
Test monotonicity using frequentist analysis with random effects for the hearing date of the case.
}
\examples{
data(synth)
data(hearingdate_synth)
synth$CourtEvent_HearingDate = hearingdate_synth
TestMonotonicityRE(synth, formula = "Y ~ Sex + White + Age + 
                   CurrentViolentOffense + PendingChargeAtTimeOfOffense + 
                   PriorMisdemeanorConviction + PriorFelonyConviction + 
                   PriorViolentConviction + (1|CourtEvent_HearingDate) + D")

}
