% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matrix_to_array_c}
\alias{matrix_to_array_c}
\title{Reshape matrix to array}
\usage{
matrix_to_array_c(matrix, times, features)
}
\arguments{
\item{matrix}{\code{matrix} containing the sequential data.}

\item{times}{\code{size_t} Number of sequences.}

\item{features}{\code{size_t} Number of features within each sequence.}
}
\value{
Returns an array. The first dimension corresponds to the cases,
the second to the times, and the third to the features.
}
\description{
Function written in C++ for reshaping a matrix containing sequential data into
an array for use with keras.
}
\seealso{
Other Utils Developers: 
\code{\link{auto_n_cores}()},
\code{\link{create_object}()},
\code{\link{create_synthetic_units_from_matrix}()},
\code{\link{generate_id}()},
\code{\link{get_n_chunks}()},
\code{\link{get_synthetic_cases_from_matrix}()},
\code{\link{tensor_to_matrix_c}()},
\code{\link{to_categorical_c}()}
}
\concept{Utils Developers}
