% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_DataManager.R
\name{get_n_chunks}
\alias{get_n_chunks}
\title{Get the number of chunks/sequences for each case}
\usage{
get_n_chunks(text_embeddings, features, times, pad_value = -100)
}
\arguments{
\item{text_embeddings}{\code{data.frame} or \code{array} containing the text embeddings.}

\item{features}{\code{int} Number of features within each sequence.}

\item{times}{\code{int} Number of sequences.}

\item{pad_value}{\code{int} Value indicating padding. This value should no be in the range of
regluar values for computations. Thus it is not recommended to chance this value.
Default is \code{-100}. Allowed values: \code{ x <= -100}}
}
\value{
Named\code{vector} of integers representing the number of chunks/sequences for every case.
}
\description{
Function for calculating the number of chunks/sequences for every case.
}
\seealso{
Other Utils Developers: 
\code{\link{auto_n_cores}()},
\code{\link{create_object}()},
\code{\link{create_synthetic_units_from_matrix}()},
\code{\link{generate_id}()},
\code{\link{get_synthetic_cases_from_matrix}()},
\code{\link{matrix_to_array_c}()},
\code{\link{tensor_to_matrix_c}()},
\code{\link{to_categorical_c}()}
}
\concept{Utils Developers}
