% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIFETransformerMaker.R
\name{aife_transformer.load_model_mlm}
\alias{aife_transformer.load_model_mlm}
\title{Load a MLM-model}
\usage{
aife_transformer.load_model_mlm(type, model_dir, from_tf, load_safe)
}
\arguments{
\item{type}{\code{string} A type of the transformer. Allowed types are bert, roberta, funnel, longformer, mpnet, modernbert. See
\link{AIFETrType} list.}

\item{model_dir}{\code{string} Path to the directory where the original model is stored. Allowed values: any}

\item{from_tf}{\code{bool} Whether to load the model weights from a TensorFlow checkpoint save file.}

\item{load_safe}{\code{bool} Whether or not to use safetensors checkpoints.}
}
\value{
If success - a MLM-model, otherwise - an error (passed type is invalid).
}
\description{
Loads a MLM-model for a transformer with the passed type.
}
\seealso{
Other Transformers for developers: 
\code{\link{.AIFEModernBertTransformer}},
\code{\link{.AIFETrConfig}},
\code{\link{.AIFETrModel}},
\code{\link{.AIFETrModelMLM}},
\code{\link{.AIFETrObj}},
\code{\link{.AIFETrTokenizer}},
\code{\link{.aife_transformer.check_type}()},
\code{\link{aife_transformer.load_model}()},
\code{\link{aife_transformer.load_model_config}()},
\code{\link{aife_transformer.load_tokenizer}()}
}
\concept{Transformers for developers}
