% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fct.R
\name{get_train_test_split}
\alias{get_train_test_split}
\title{Function for splitting data into a train and validation sample}
\usage{
get_train_test_split(embedding, target, val_size)
}
\arguments{
\item{embedding}{Object of class \link{EmbeddedText}.}

\item{target}{Named \code{factor} containing the labels of every case.}

\item{val_size}{\code{double} Ratio between 0 and 1 indicating the relative
frequency of cases which should be used as validation sample.}
}
\value{
Returns a \code{list} with the following components.
\itemize{
\item{\code{target_train: }Named \code{factor} containing the labels of the training sample.}

\item{\code{embeddings_train: }Object of class \link{EmbeddedText} containing the text embeddings for the training sample}

\item{\code{target_test: }Named \code{factor} containing the labels of the validation sample.}

\item{\code{embeddings_test: }Object of class \link{EmbeddedText} containing the text embeddings for the validation sample}
}
}
\description{
This function creates a train and validation sample based on stratified random
sampling. The relative frequencies of each category in the train and validation sample
equal the relative frequencies of the initial data (proportional stratified sampling).
}
\seealso{
Other Auxiliary Functions: 
\code{\link{array_to_matrix}()},
\code{\link{calc_standard_classification_measures}()},
\code{\link{check_embedding_models}()},
\code{\link{create_iota2_mean_object}()},
\code{\link{create_synthetic_units}()},
\code{\link{generate_id}()},
\code{\link{get_coder_metrics}()},
\code{\link{get_folds}()},
\code{\link{get_n_chunks}()},
\code{\link{get_stratified_train_test_split}()},
\code{\link{get_synthetic_cases}()},
\code{\link{matrix_to_array_c}()},
\code{\link{split_labeled_unlabeled}()},
\code{\link{summarize_tracked_sustainability}()},
\code{\link{to_categorical_c}()}
}
\concept{Auxiliary Functions}
\keyword{internal}
