% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_reweighing.R
\name{reweighing}
\alias{reweighing}
\title{Reweighing}
\usage{
reweighing(unprivileged_groups, privileged_groups)
}
\arguments{
\item{unprivileged_groups}{a list with two values: the column of the protected class and the value indicating representation for unprivileged group}

\item{privileged_groups}{a list with two values: the column of the protected class and the value indicating representation for privileged group}
}
\description{
Reweighing is a preprocessing technique that weights the examples in each (group, label) combination differently to ensure fairness before classification
}
\examples{
\donttest{
# An example using the Adult Dataset
load_aif360_lib()
ad <- adult_dataset()
p <- list("race", 1)
u <- list("race", 0)
rw <- reweighing(u,p)
rw$fit(ad)
ad_transformed <- rw$transform(ad)
ad_fit_transformed <- rw$fit_transform(ad)
}
}
