% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-normalization.R
\name{get_log_normconst}
\alias{get_log_normconst}
\alias{get_log_normconst.default}
\alias{get_log_normconst.numeric}
\alias{get_log_normconst.aghq}
\alias{get_log_normconst.laplace}
\alias{get_log_normconst.marginallaplace}
\title{Obtain the log-normalizing constant from a fitted quadrature object}
\usage{
get_log_normconst(obj, ...)

\method{get_log_normconst}{default}(obj, ...)

\method{get_log_normconst}{numeric}(obj, ...)

\method{get_log_normconst}{aghq}(obj, ...)

\method{get_log_normconst}{laplace}(obj, ...)

\method{get_log_normconst}{marginallaplace}(obj, ...)
}
\arguments{
\item{obj}{A list returned by \code{aghq::normalize_posterior} or an object of class \code{aghq}, \code{laplace}, or \code{marginallaplace}.}

\item{...}{Not used}
}
\value{
A number representing the natural logarithm of the approximated normalizing constant.
}
\description{
Quick helper S3 method to retrieve the log normalizing constant from an object
created using the aghq package. Methods for a list (returned by \code{aghq::normalize_posterior})
and for objects of class \code{aghq}, \code{laplace}, and \code{marginallaplace}.
}
\seealso{
Other quadrature: 
\code{\link{aghq}()},
\code{\link{laplace_approximation}()},
\code{\link{marginal_laplace_tmb}()},
\code{\link{marginal_laplace}()},
\code{\link{normalize_logpost}()},
\code{\link{optimize_theta}()},
\code{\link{plot.aghq}()},
\code{\link{print.aghqsummary}()},
\code{\link{print.aghq}()},
\code{\link{print.laplacesummary}()},
\code{\link{print.laplace}()},
\code{\link{print.marginallaplacesummary}()},
\code{\link{summary.aghq}()},
\code{\link{summary.laplace}()},
\code{\link{summary.marginallaplace}()}
}
\concept{quadrature}
