% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-misc-support-functions.R
\name{default_control}
\alias{default_control}
\title{Default control arguments for \code{aghq::aghq()}.}
\usage{
default_control(...)
}
\arguments{
\item{...}{You can provide a named value for any control parameter and its
value will be set accordingly. See \code{?aghq} and examples here.}
}
\value{
A list of argument values.
}
\description{
Run \code{default_control()} to print the list of valid control parameters
and their defaults, and run with named arguments to change the defaults.
}
\details{
Valid options are:
\itemize{
\item{\code{method}: }{optimization method to use:
\itemize{
\item{'BFGS' (default): }{\code{optim(...,method = "BFGS")}}
\item{'sparse_trust': }{\code{trustOptim::trust.optim}}
\item{'SR1': }{\code{trustOptim::trust.optim} with \code{method = 'SR1'}}
\item{'sparse': }{\code{trust::trust}}
}
Default is 'sparse_trust'.
}
\item \code{negate}: default \code{FALSE}. Multiply the functions in \code{ff} by \code{-1}?
The reason for having this option is for full compatibility with \code{TMB}:
while of course \code{TMB} allows you to code up your log-posterior any way you like,
all of its excellent features including its automatic Laplace approximation and MCMC
sampling with \code{tmbstan} assume you have coded your template to return the
\strong{negated} log-posterior. However, by default, \code{aghq} assumes you have
provided the log-posterior \strong{without negation}. Set \code{negate = TRUE} if you
have provided a template which computes the \strong{negated} log-posterior and its
derivatives.
\item \code{ndConstruction}: construct a multivariate quadrature rule using a \code{"product"}
rule or a \code{"sparse"} grid? Default \code{"product"}. See \code{?mvQuad::createNIGrid()}.
\item \code{interpolation}: how to interpolate the marginal posteriors. The \code{'auto'} option
(default) chooses for you and should always work well. The \code{'polynomial'}
option uses \code{polynom::poly.calc()} to construct a global polynomial interpolant
and has been observed to be unstable as the number of quadrature points gets larger, which
is obviously a bad thing. Try \code{'spline'} instead, which uses a cubic B-Spline
interpolant from \code{splines::interpSpline()}.
\item{numhessian}: logical, default \code{FALSE}. Replace the \code{ff$he} with a numerically-differentiated
version, by calling \code{numDeriv::jacobian} on \code{ff$gr}. Used mainly for \code{TMB} with the automatic
Laplace approximation, which does not have an automatic Hessian.
\item{onlynormconst}: logical, default \code{FALSE}. Skip everything after the calculation of the log integral,
and just return the numeric value of the log integral. Saves computation time, and most useful in cases
where \code{aghq} is being used as a step in a more complicated procedure.
}
}
\examples{

default_control()
default_control(method = "trust")
default_control(negate = TRUE)

}
