% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-misc-support-functions.R
\name{default_control_tmb}
\alias{default_control_tmb}
\title{Default control arguments for \code{aghq::marginal_laplace()}.}
\usage{
default_control_tmb(...)
}
\arguments{
\item{...}{You can provide a named value for any control parameter and its
value will be set accordingly. See \code{?marginal_laplace} and examples here.}
}
\value{
A list of argument values.
}
\description{
Run \code{default_control_marglaplace()} to print the list of valid control parameters
and their defaults, and run with named arguments to change the defaults.
}
\details{
Valid options are:
\itemize{
\item{\code{method}: }{optimization method to use for the \code{theta} optimization:
\itemize{
\item{'sparse_trust' (default): }{\code{trustOptim::trust.optim}}
\item{'sparse': }{\code{trust::trust}}
\item{'BFGS': }{\code{optim(...,method = "BFGS")}}
}
}
\item \code{negate}: {default \code{TRUE}. Assumes that your \code{TMB} function
template computes the \strong{negated} log-posterior, which it must if you're using \code{TMB}'s automatic
Laplace approximation, which you must be if you're using this function!}.
}
}
\examples{

default_control_marglaplace()
default_control_marglaplace(method = "trust")
default_control_marglaplace(method = "trust",inner_method = "trust")
default_control_marglaplace(negate = TRUE)

}
