% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-aghq.R
\name{laplace_approximation}
\alias{laplace_approximation}
\title{Laplace Approximation}
\usage{
laplace_approximation(
  ff,
  startingvalue,
  optresults = NULL,
  control = default_control(),
  ...
)
}
\arguments{
\item{ff}{A list with three elements:
\itemize{
\item{\code{fn}}{: function taking argument \code{theta} and returning a numeric
value representing the log-posterior at \code{theta}}
\item{\code{gr}}{: function taking argument \code{theta} and returning a numeric
vector representing the gradient of the log-posterior at \code{theta}}
\item{\code{he}}{: function taking argument \code{theta} and returning a numeric
matrix representing the hessian of the log-posterior at \code{theta}}
}
The user may wish to use \code{numDeriv::grad} and/or \code{numDeriv::hessian} to
obtain these. Alternatively, the user may consider the \code{TMB} package. This
list is deliberately formatted to match the output of \code{TMB::MakeADFun}.}

\item{startingvalue}{Value to start the optimization. \code{ff$fn(startingvalue)},
\code{ff$gr(startingvalue)}, and \code{ff$he(startingvalue)} must all return
appropriate values without error.}

\item{optresults}{Optional. A list of the results of the optimization of the log
posterior, formatted according to the output of \code{aghq::optimize_theta}. The
\code{aghq::aghq} function handles the optimization for you; passing this list
overrides this, and is useful for when you know your optimization is too difficult to be
handled by general-purpose software. See the software paper for several examples of this.
If you're unsure whether this option is needed for your problem then it probably is not.}

\item{control}{A list with elements
\itemize{
\item{\code{method}: }{optimization method to use:
\itemize{
\item{'sparse_trust' (default): }{\code{trustOptim::trust.optim} with \code{method = 'sparse'}}
\item{'SR1' (default): }{\code{trustOptim::trust.optim} with \code{method = 'SR1'}}
\item{'trust': }{\code{trust::trust}}
\item{'BFGS': }{\code{optim(...,method = "BFGS")}}
}
Default is 'sparse_trust'.
}
\item{\code{optcontrol}: }{optional: a list of control parameters to pass to the
internal optimizer you chose. The \code{aghq} package uses sensible defaults.}
}}

\item{...}{Additional arguments to be passed to \code{ff$fn}, \code{ff$gr}, and \code{ff$he}.}
}
\value{
An object of class \code{laplace} with summary and plot methods. This
is simply a list with elements \code{lognormconst} containing the log of the
approximate normalizing constant, and \code{optresults} containing the optimization
results formatted the same way as \code{optimize_theta} and \code{aghq}.
}
\description{
Wrapper function to implement a Laplace approximation to the posterior. A
Laplace approximation is AGHQ with \code{k = 1} quadrature points.
However, the returned
object is of a different class \code{laplace}, and a different summary
method is given for it. It is especially useful for high-dimensional problems where
the curse of dimensionality renders the use of \code{k > 1} quadrature points
infeasible. The summary method reflects the fact that the user may
be using this for a high-dimensional problem, and no plot method is given,
because there isn't anything
interesting to plot.
}
\examples{

logfteta2d <- function(eta,y) {
  # eta is now (eta1,eta2)
  # y is now (y1,y2)
  n <- length(y)
  n1 <- ceiling(n/2)
  n2 <- floor(n/2)
  y1 <- y[1:n1]
  y2 <- y[(n1+1):(n1+n2)]
  eta1 <- eta[1]
  eta2 <- eta[2]
  sum(y1) * eta1 - (length(y1) + 1) * exp(eta1) - sum(lgamma(y1+1)) + eta1 +
    sum(y2) * eta2 - (length(y2) + 1) * exp(eta2) - sum(lgamma(y2+1)) + eta2
}
set.seed(84343124)
n1 <- 5
n2 <- 5
n <- n1+n2
y1 <- rpois(n1,5)
y2 <- rpois(n2,5)
objfunc2d <- function(x) logfteta2d(x,c(y1,y2))
funlist2d <- list(
  fn = objfunc2d,
  gr = function(x) numDeriv::grad(objfunc2d,x),
  he = function(x) numDeriv::hessian(objfunc2d,x)
)

thequadrature <- aghq(funlist2d,3,c(0,0))

}
\seealso{
Other quadrature: 
\code{\link{aghq}()},
\code{\link{marginal_laplace_tmb}()},
\code{\link{marginal_laplace}()},
\code{\link{normalize_logpost}()},
\code{\link{optimize_theta}()},
\code{\link{plot.aghq}()},
\code{\link{print.aghqsummary}()},
\code{\link{print.aghq}()},
\code{\link{print.laplacesummary}()},
\code{\link{print.laplace}()},
\code{\link{summary.aghq}()},
\code{\link{summary.laplace}()}
}
\concept{quadrature}
