% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{compute_pdf_and_cdf}
\alias{compute_pdf_and_cdf}
\title{Density and Cumulative Distribution Function}
\usage{
compute_pdf_and_cdf(margpost, transformation = NULL, finegrid = NULL)
}
\arguments{
\item{margpost}{The output of \code{aghq::marginal_posterior}. See the documentation for that function.}

\item{transformation}{Optional. A list containing two functions, \code{fromtheta}
and \code{totheta}, which accept and return numeric vectors, defining a parameter transformation for which you would
also like the pdf calculated for. See examples. May also have an element \code{jacobian},
a function which takes a numeric vector and computes the jacobian of the transformation; if
not provided, this is done using \code{numDeriv::jacobian}.}

\item{finegrid}{Optional, a grid of values on which to compute the CDF. The default makes
use of the values in \code{margpost} but if the results are unsuitable, you may wish to
modify this manually.}
}
\value{
A tbl_df/tbl/data.frame with columns \code{theta}, \code{pdf} and \code{cdf} corresponding
to the value of the parameter and its estimated PDF and CDF at that value.
}
\description{
Compute the density and cumulative distribution function of the approximate posterior.
The density is approximated on a find grid using a polynomial interpolant.
The CDF can't be computed exactly (if it could, you wouldn't be using quadrature!),
so a fine grid is laid down and the CDF is approximated at each grid point
using a simpler integration rule and a polynomial interpolant. This method tends
to work well, but won't always.
}
\examples{
logfteta2d <- function(eta,y) {
  # eta is now (eta1,eta2)
  # y is now (y1,y2)
  n <- length(y)
  n1 <- ceiling(n/2)
  n2 <- floor(n/2)
  y1 <- y[1:n1]
  y2 <- y[(n1+1):(n1+n2)]
  eta1 <- eta[1]
  eta2 <- eta[2]
  sum(y1) * eta1 - (length(y1) + 1) * exp(eta1) - sum(lgamma(y1+1)) + eta1 +
    sum(y2) * eta2 - (length(y2) + 1) * exp(eta2) - sum(lgamma(y2+1)) + eta2
}
set.seed(84343124)
n1 <- 5
n2 <- 5
n <- n1+n2
y1 <- rpois(n1,5)
y2 <- rpois(n2,5)
objfunc2d <- function(x) logfteta2d(x,c(y1,y2))
funlist2d <- list(
  fn = objfunc2d,
  gr = function(x) numDeriv::grad(objfunc2d,x),
  he = function(x) numDeriv::hessian(objfunc2d,x)
)
opt_sparsetrust_2d <- optimize_theta(funlist2d,c(1.5,1.5))
margpost <- marginal_posterior(opt_sparsetrust_2d,3,1) # margpost for theta1
thepdfandcdf <- compute_pdf_and_cdf(margpost)
with(thepdfandcdf,{
  plot(pdf~theta,type='l')
  plot(cdf~theta,type='l')
})

}
\seealso{
Other summaries: 
\code{\link{compute_moment}()},
\code{\link{compute_quantiles}()},
\code{\link{interpolate_marginal_posterior}()},
\code{\link{marginal_posterior}()}
}
\concept{summaries}
