% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior.R, R/PointMassPrior.R,
%   R/ContinuousPrior.R
\name{expectation}
\alias{expectation}
\alias{expectation,PointMassPrior,function-method}
\alias{expectation,ContinuousPrior,function-method}
\title{Expected value of a function}
\usage{
expectation(dist, f, ...)

\S4method{expectation}{PointMassPrior,function}(dist, f, ...)

\S4method{expectation}{ContinuousPrior,function}(dist, f, ...)
}
\arguments{
\item{dist}{a univariate \code{\link[=DataDistribution-class]{distribution}} object}

\item{f}{a univariate function, must be vectorized}

\item{...}{further optional arguments}
}
\value{
\code{numeric}, expected value of \code{f} with respect to \code{dist}
}
\description{
Computes the expected value of a vectorized, univariate function \code{f}
with respect to a distribution \code{dist}.
I.e., \ifelse{html}{\out{E[f(X)]}}{\eqn{\boldsymbol{E}\big[f(X)\big]}{E[f(X)]}}.
}
\examples{
expectation(PointMassPrior(c(0, .5), c(.3, .7)), identity)
# > .35

expectation(
    ContinuousPrior(function(x) dunif(x, .2, .4), c(.2, .4)),
    identity
)
# > 0.3

}
