% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior.R, R/PointMassPrior.R,
%   R/ContinuousPrior.R
\name{bounds}
\alias{bounds}
\alias{bounds,PointMassPrior-method}
\alias{bounds,ContinuousPrior-method}
\title{Get support of a prior or data distribution}
\usage{
bounds(dist, ...)

\S4method{bounds}{PointMassPrior}(dist, ...)

\S4method{bounds}{ContinuousPrior}(dist, ...)
}
\arguments{
\item{dist}{a univariate \code{\link[=DataDistribution-class]{distribution}} object}

\item{...}{further optional arguments}
}
\value{
\code{numeric} of length two, \code{c(lower, upper)}
}
\description{
\code{bounds()} returns the range of the support of a prior or data distribution.
}
\examples{
bounds(PointMassPrior(c(0, .5), c(.3, .7)))
# > 0.3 0.7

bounds(ContinuousPrior(function(x) dunif(x, .2, .4), c(.2, .4)))
# > 0.2 0.4

}
