% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoStageDesign.R
\docType{methods}
\name{plot,TwoStageDesign-method}
\alias{plot,TwoStageDesign-method}
\title{Plot \code{TwoStageDesign} with optional set of conditional scores}
\usage{
\S4method{plot}{TwoStageDesign}(x, y = NULL, rounded = TRUE, ...,
  k = 100)
}
\arguments{
\item{x}{design to plot}

\item{y}{not used}

\item{rounded}{should n-values be rounded?}

\item{...}{further named \code{ConditinonalScores} to plot for the design}

\item{k}{number of points to use for plotting}
}
\description{
This method allows to plot the stage-two sample size and decision boundary
functions of a chosen design.
}
\details{
\code{\link{TwoStageDesign}} and
user-defined elements of the class \code{\link[=Scores]{ConditionalScore}}.
}
\examples{
design <- TwoStageDesign(50, 0, 2, 50, 2, 5)
cp     <- ConditionalPower(dist = Normal(), prior = PointMassPrior(.4, 1))
plot(design, "Conditional Power" = cp)

}
\seealso{
\code{\link{TwoStageDesign}}
}
