% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scores.R
\docType{class}
\name{ConditionalScore-class}
\alias{ConditionalScore-class}
\alias{ConditionalScore}
\alias{show,ConditionalScore-method}
\title{Class for conditional scoring function}
\usage{
\S4method{show}{ConditionalScore}(object)
}
\arguments{
\item{object}{object of class \code{ConditionalScore}}
}
\description{
\code{ConditionalScore} is an abstract class for conditional scores.
It requires the two slots \code{distribution} and \code{prior} that
determine the data distribution and the prior distribution for the effect
parameter. When defining a specific  \code{ConditionalScore}, a corresponding
method \code{evaluate} needs to be defined, too.
Any \code{ConditionalScore} can be transformed to an unconditional
\code{\link{IntegralScore}} by means of the method \code{\link{expected}}.
}
\examples{
cp <- ConditionalPower(Normal(), PointMassPrior(0, 1))
ep <- expected(cp)
design <- TwoStageDesign(50, 0, 2, 50, 2, 5)
evaluate(ep, design)

}
\seealso{
The common conditional scores \code{\link{ConditionalPower}}
   and \code{\link{ConditionalSampleSize}} are preimplemented in \pkg{adoptr}.
}
