% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatraSen_density_est.R
\name{PatraSen_density_est}
\alias{PatraSen_density_est}
\title{Compute the estimate of the density of the unknown component in an admixture model}
\usage{
PatraSen_density_est(input, dec.density = TRUE)
}
\arguments{
\item{input}{an R object of class 'cv.mixmodel' or 'mixmodel'.}

\item{dec.density}{a boolean indicating whether the density is increasing or decreasing.}
}
\value{
an estimator of the unknown component density.
}
\description{
Compute by Patra and Sen technique the estimate of f.s (density corresponding to F.s) when f.s is known to
be either decreasing or increasing.
}
\details{
See Patra, R.K. and Sen, B. (2016); Estimation of a Two-component Mixture Model with Applications to Multiple Testing;
JRSS Series B, 78, pp. 869--893.
}
\examples{
comp.dist <- list(f = 'norm', g = 'norm')
comp.param <- list(f = list(mean = 3, sd = 0.5), g = list(mean = 0, sd = 1))
data1 <- rsimmix(n = 2000, unknownComp_weight = 0.6, comp.dist, comp.param)[['mixt.data']]
data1_transfo <- knownComp_to_uniform(data = data1, comp.dist = list(comp.dist$f, comp.dist$g),
                                      comp.param = list(comp.param$f, comp.param$g))
res <- PatraSen_cv_mixmodel(data = data1_transfo, folds = 3, reps = 1, cn.s = NULL,
                            cn.length = 3, gridsize = 200)
PatraSen_density_est(res, dec.density = TRUE)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
