% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix_clustering.R
\name{admix_clustering}
\alias{admix_clustering}
\title{Clustering of K populations following admixture models}
\usage{
admix_clustering(
  samples = NULL,
  n_sim_tab = 100,
  comp.dist = NULL,
  comp.param = NULL,
  parallel = FALSE,
  n_cpu = 2
)
}
\arguments{
\item{samples}{A list of the K observed samples to be clustered, all following admixture distributions.}

\item{n_sim_tab}{Number of simulated gaussian processes used in the tabulation of the inner convergence distribution in the IBM approach.}

\item{comp.dist}{A list with 2*K elements corresponding to the component distributions (specified with R native names for these distributions)
involved in the K admixture models. Elements, grouped by 2, refer to the unknown and known components of each admixture model,
If there are unknown elements, they must be specified as 'NULL' objects. For instance, 'comp.dist' could be specified
as follows with K = 3: list(f1 = NULL, g1 = 'norm', f2 = NULL, g2 = 'norm', f3 = NULL, g3 = 'rnorm').}

\item{comp.param}{A list with 2*K elements corresponding to the parameters of the component distributions, each element being a list
itself. The names used in this list must correspond to the native R argument names for these distributions.
Elements, grouped by 2, refer to the parameters of unknown and known components of each admixture model.
If there are unknown elements, they must be specified as 'NULL' objects. For instance, 'comp.param' could
be specified as follows (with K = 3):
list(f1 = NULL, g1 = list(mean=0,sd=1), f2 = NULL, g2 = list(mean=3,sd=1.1), f3 = NULL, g3 = list(mean=-2,sd=0.6)).}

\item{parallel}{(default to FALSE) Boolean to indicate whether parallel computations are performed (speed-up the tabulation).}

\item{n_cpu}{(default to 2) Number of cores used when parallelizing.}
}
\value{
A list with three elements: 1) the identified clusters; 2) the cluster affiliation; 3) the discrepancy matrix.
}
\description{
Create clusters on the unknown components related to the K populations following admixture models. Based on the K-sample test
using Inversion - Best Matching (IBM) approach, see 'Details' below for further information.
}
\details{
See the paper presenting the IBM approach at the following HAL weblink: https://hal.archives-ouvertes.fr/hal-03201760
}
\examples{
\donttest{
## Simulate data (chosen parameters indicate 2 clusters (populations (1,3), (2,4))!):
list.comp <- list(f1 = "gamma", g1 = "exp",
                  f2 = "gamma", g2 = "exp",
                  f3 = "gamma", g3 = "gamma",
                  f4 = "gamma", g4 = "exp")
list.param <- list(f1 = list(shape = 16, rate = 4), g1 = list(rate = 1/3.5),
                   f2 = list(shape = 14, rate = 2), g2 = list(rate = 1/5),
                   f3 = list(shape = 16, rate = 4), g3 = list(shape = 12, rate = 2),
                   f4 = list(shape = 14, rate = 2), g4 = list(rate = 1/7))
A.sim <- rsimmix(n=2600, unknownComp_weight=0.8, comp.dist = list(list.comp$f1,list.comp$g1),
                 comp.param = list(list.param$f1, list.param$g1))$mixt.data
B.sim <- rsimmix(n=3000, unknownComp_weight=0.7, comp.dist = list(list.comp$f2,list.comp$g2),
                 comp.param = list(list.param$f2, list.param$g2))$mixt.data
C.sim <- rsimmix(n=3500, unknownComp_weight=0.6, comp.dist = list(list.comp$f3,list.comp$g3),
                 comp.param = list(list.param$f3, list.param$g3))$mixt.data
D.sim <- rsimmix(n=4800, unknownComp_weight=0.5, comp.dist = list(list.comp$f4,list.comp$g4),
                 comp.param = list(list.param$f4, list.param$g4))$mixt.data
## Look for the clusters:
list.comp <- list(f1 = NULL, g1 = "exp",
                  f2 = NULL, g2 = "exp",
                  f3 = NULL, g3 = "gamma",
                  f4 = NULL, g4 = "exp")
list.param <- list(f1 = NULL, g1 = list(rate = 1/3.5),
                   f2 = NULL, g2 = list(rate = 1/5),
                   f3 = NULL, g3 = list(shape = 12, rate = 2),
                   f4 = NULL, g4 = list(rate = 1/7))
clusters <- admix_clustering(samples = list(A.sim,B.sim,C.sim,D.sim), n_sim_tab = 8,
                             comp.dist=list.comp, comp.param=list.param, parallel=FALSE, n_cpu=2)
clusters$clustering
}

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
